/*
 * Decompiled with CFR 0.152.
 */
package trofers.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public abstract class JsonHelper {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FABRIC = "fabric";
    private static final String FABRIC_LOAD_CONDITIONS = new class_2960("fabric", "load_conditions").toString();
    private static final String FABRIC_ALL_MODS_LOADED = new class_2960("fabric", "all_mods_loaded").toString();
    private static final String FORGE_CONDITIONS = "conditions";
    private static final String FORGE_MOD_LOADED = new class_2960("forge", "mod_loaded").toString();

    public static class_1799 deserializeItem(JsonObject object, String memberName) {
        return JsonHelper.getItemStack(class_3518.method_15296((JsonObject)object, (String)memberName), true);
    }

    public static class_1799 getItemStack(JsonObject json, boolean readNBT) {
        String itemName = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = JsonHelper.getItem(itemName);
        if (readNBT && json.has("nbt")) {
            class_2487 nbt = JsonHelper.parseNBT(json.get("nbt"));
            class_2487 itemTag = new class_2487();
            if (nbt.method_10545("ForgeCaps")) {
                itemTag.method_10566("ForgeCaps", nbt.method_10580("ForgeCaps"));
                nbt.method_10551("ForgeCaps");
            }
            itemTag.method_10566("tag", (class_2520)nbt);
            itemTag.method_10582("id", itemName);
            itemTag.method_10569("Count", class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
            return class_1799.method_7915((class_2487)itemTag);
        }
        return new class_1799((class_1935)item, class_3518.method_15282((JsonObject)json, (String)"count", (int)1));
    }

    public static class_2487 parseNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + String.valueOf((Object)exception));
        }
    }

    public static class_1792 getItem(String id) {
        class_2960 key = new class_2960(id);
        if (!class_7923.field_41178.method_10250(key)) {
            throw new JsonSyntaxException("Unknown item '" + id + "'");
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(key);
        if (item == class_1802.field_8162) {
            throw new JsonSyntaxException("Invalid item: " + id);
        }
        return item;
    }

    public static JsonObject serializeItem(class_1799 item) {
        JsonObject result = new JsonObject();
        result.addProperty("item", class_7923.field_41178.method_10221((Object)item.method_7909()).toString());
        if (item.method_7947() != 1) {
            result.addProperty("count", (Number)item.method_7947());
        }
        if (item.method_7985()) {
            result.addProperty("nbt", item.method_7969().toString());
        }
        return result;
    }

    public static class_2487 deserializeNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return class_2522.method_10718((String)GSON.toJson(element));
            }
            return class_2522.method_10718((String)class_3518.method_15287((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException exception) {
            throw new JsonSyntaxException(String.format("Invalid NBT Entry: %s", new Object[]{exception}));
        }
    }

    public static float readOptionalFloat(JsonObject object, String memberName, int defaultValue) {
        if (object.has(memberName)) {
            return class_3518.method_15259((JsonObject)object, (String)memberName);
        }
        return defaultValue;
    }

    private static JsonArray getOrCreateList(JsonObject object, String name) {
        if (object.has(name)) {
            return object.getAsJsonArray(name);
        }
        JsonArray conditions = new JsonArray();
        object.add(name, (JsonElement)conditions);
        return conditions;
    }

    private static JsonObject createCondition(JsonObject object, String conditionsName, String conditionName, String conditionValue) {
        JsonArray conditions = JsonHelper.getOrCreateList(object, conditionsName);
        JsonObject condition = new JsonObject();
        conditions.add((JsonElement)condition);
        condition.addProperty(conditionName, conditionValue);
        return condition;
    }

    private static JsonObject createFabricCondition(JsonObject object, String type) {
        return JsonHelper.createCondition(object, FABRIC_LOAD_CONDITIONS, "condition", type);
    }

    private static JsonObject createForgeCondition(JsonObject object, String type) {
        return JsonHelper.createCondition(object, FORGE_CONDITIONS, "type", type);
    }

    public static void addModLoadedConditions(JsonObject object, String ... modIds) {
        if (modIds.length == 0) {
            return;
        }
        JsonHelper.addFabricModLoadedCondition(object, modIds);
        JsonHelper.addForgeModLoadedCondition(object, modIds);
    }

    private static void addFabricModLoadedCondition(JsonObject object, String ... modIds) {
        JsonObject condition = JsonHelper.createFabricCondition(object, FABRIC_ALL_MODS_LOADED);
        JsonArray mods = JsonHelper.getOrCreateList(condition, "values");
        for (String modId : modIds) {
            mods.add(modId);
        }
    }

    private static void addForgeModLoadedCondition(JsonObject object, String ... modIds) {
        for (String modId : modIds) {
            JsonHelper.createForgeCondition(object, FORGE_MOD_LOADED).addProperty("modid", modId);
        }
    }
}

