/*
 * Decompiled with CFR 0.152.
 */
package trofers.block.entity;

import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;
import trofers.Trofers;
import trofers.block.TrophyBlock;
import trofers.registry.ModBlockEntityTypes;
import trofers.registry.ModDataComponents;
import trofers.registry.ModRegistries;
import trofers.trophy.Trophy;
import trofers.trophy.components.EffectInfo;

public class TrophyBlockEntity
extends class_2586 {
    public static final class_5558<TrophyBlockEntity> TICKER = (level, pos, state, blockEntity) -> blockEntity.tick();
    @Nullable
    private class_2960 trophyID;
    private int rewardCooldown;
    private float animationOffset;

    public TrophyBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntityTypes.TROPHY.get(), pos, state);
    }

    @Nullable
    public Trophy getTrophy() {
        return ModRegistries.get(ModRegistries.TROPHIES, this.trophyID);
    }

    public void setTrophy(@Nullable class_2960 trophyId, class_3222 player) {
        this.trophyID = trophyId;
        this.resetRewardCooldown(player);
        this.onContentsChanged();
    }

    public class_1799 getItem() {
        class_1799 stack = new class_1799((class_1935)this.method_11010().method_26204().method_8389());
        stack.method_57365(this.method_57590());
        return stack;
    }

    public float getAnimationOffset() {
        if (this.animationOffset == 0.0f && this.field_11863 != null) {
            this.animationOffset = this.field_11863.method_8409().method_43057() * 4000.0f;
        }
        return this.animationOffset;
    }

    public int getTrophyHeight() {
        class_2248 block = this.method_11010().method_26204();
        if (block instanceof TrophyBlock) {
            TrophyBlock trophy = (TrophyBlock)block;
            return trophy.getHeight();
        }
        return 0;
    }

    public void resetRewardCooldown(@Nullable class_3222 player) {
        Trophy trophy = this.getTrophy();
        this.rewardCooldown = (player == null || !player.method_7337()) && trophy != null && trophy.effects().rewards().cooldown() > 0 ? trophy.effects().rewards().cooldown() : 0;
    }

    public void tick() {
        if (this.rewardCooldown > 0) {
            --this.rewardCooldown;
            if (this.field_11863 != null) {
                this.field_11863.method_8524(this.method_11016());
            }
        }
    }

    public boolean applyEffect(class_1657 player) {
        Trophy trophy = this.getTrophy();
        if (trophy == null || this.field_11863 == null) {
            return false;
        }
        EffectInfo.RewardInfo rewards = trophy.effects().rewards();
        trophy.effects().sound().ifPresent(sound -> {
            class_1937 patt0$temp = this.field_11863;
            if (patt0$temp instanceof class_3218) {
                class_3218 serverLevel = (class_3218)patt0$temp;
                class_243 pos = class_243.method_24953((class_2382)this.method_11016());
                TrophyBlockEntity.playSound(serverLevel, sound.soundEvent(), pos, sound.volume(), sound.pitch());
            }
        });
        this.giveRewards(rewards, player);
        return trophy.effects().sound().isPresent() || rewards.lootTable().isPresent() && Trofers.CONFIG.general.enableTrophyLoot != false || rewards.mobEffect().isPresent() && Trofers.CONFIG.general.enableTrophyEffects != false;
    }

    private static void playSound(class_3218 level, class_2960 sound, class_243 pos, float volume, float pitch) {
        double maxDistance = Math.pow(volume > 1.0f ? (double)volume * 16.0 : 16.0, 2.0);
        long seed = level.method_8409().method_43055();
        for (class_3222 player : level.method_18456()) {
            double z;
            double y;
            double x = pos.field_1352 - player.method_23317();
            double distance = x * x + (y = pos.field_1351 - player.method_23318()) * y + (z = pos.field_1350 - player.method_23321()) * z;
            if (distance > maxDistance) continue;
            class_6880 holder = class_6880.method_40223((Object)class_3414.method_47908((class_2960)sound));
            player.field_13987.method_14364((class_2596)new class_2767(holder, class_3419.field_15245, pos.method_10216(), pos.method_10214(), pos.method_10215(), volume, pitch, seed));
        }
    }

    private void giveRewards(EffectInfo.RewardInfo rewards, class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (!(Trofers.CONFIG.general.enableTrophyLoot.booleanValue() && !rewards.lootTable().isEmpty() || Trofers.CONFIG.general.enableTrophyEffects.booleanValue() && !rewards.mobEffect().isEmpty())) {
            return;
        }
        if (this.rewardCooldown > 0) {
            player.method_7353((class_2561)class_2561.method_43469((String)String.format("message.%s.reward_cooldown", "trofers"), (Object[])new Object[]{this.getTime(this.rewardCooldown)}), true);
            return;
        }
        this.resetRewardCooldown(serverPlayer);
        this.rewardLoot(rewards);
        this.rewardMobEffect(rewards, player);
    }

    private class_2561 getTime(int ticks) {
        int seconds = (ticks + 20) / 20;
        if (seconds <= 1) {
            return class_2561.method_43471((String)"time.trofers.second");
        }
        if (seconds < 60) {
            return class_2561.method_43469((String)"time.trofers.seconds", (Object[])new Object[]{seconds});
        }
        int minutes = seconds / 60;
        if (minutes == 1) {
            return class_2561.method_43471((String)"time.trofers.minute");
        }
        if (minutes < 60) {
            return class_2561.method_43469((String)"time.trofers.minutes", (Object[])new Object[]{minutes});
        }
        int hours = minutes / 60;
        if (hours == 1) {
            return class_2561.method_43471((String)"time.trofers.hour");
        }
        return class_2561.method_43469((String)"time.trofers.hours", (Object[])new Object[]{hours});
    }

    private void rewardMobEffect(EffectInfo.RewardInfo rewards, class_1657 player) {
        if (Trofers.CONFIG.general.enableTrophyEffects.booleanValue()) {
            rewards.mobEffect().map(EffectInfo.MobEffectInfo::createInstance).ifPresent(arg_0 -> ((class_1657)player).method_6092(arg_0));
        }
    }

    private void rewardLoot(EffectInfo.RewardInfo rewards) {
        if (Trofers.CONFIG.general.enableTrophyLoot.booleanValue()) {
            rewards.lootTable().ifPresent(lootTableLocation -> {
                class_52 lootTable = this.field_11863.method_8503().method_58576().method_58295(lootTableLocation);
                if (lootTable == class_52.field_948) {
                    Trofers.LOGGER.log(Level.ERROR, "Invalid loot table: {}", lootTableLocation);
                    return;
                }
                class_8567 parameters = new class_8567.class_8568((class_3218)this.field_11863).method_51875(class_173.field_1175);
                lootTable.method_51878(parameters).forEach(this::spawnAtLocation);
            });
        }
    }

    public void spawnAtLocation(class_1799 stack) {
        if (!stack.method_7960() && this.field_11863 != null && !this.field_11863.field_9236) {
            class_1542 item = new class_1542(this.field_11863, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + (double)this.getTrophyHeight() / 16.0 + 0.2, (double)this.method_11016().method_10260() + 0.5, stack);
            item.method_6988();
            this.field_11863.method_8649((class_1297)item);
        }
    }

    private void onContentsChanged() {
        if (this.field_11863 != null) {
            if (!this.field_11863.method_8608()) {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
                this.method_5431();
            } else {
                this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
            }
        }
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        this.loadTrophy(tag);
        this.rewardCooldown = tag.method_10550("RewardCooldown");
    }

    public void loadTrophy(class_2487 tag) {
        this.trophyID = null;
        if (tag.method_10573("Trophy", 8)) {
            try {
                this.trophyID = class_2960.method_60654((String)tag.method_10558("Trophy"));
            }
            catch (class_151 exception) {
                Trofers.LOGGER.error(String.format("Failed to load trophy for block entity at %s", this.method_11016()), (Throwable)exception);
            }
            Trophy trophy = ModRegistries.get(ModRegistries.TROPHIES, this.trophyID);
            if (trophy == null && ModRegistries.trophies().isPresent()) {
                Trofers.LOGGER.error(String.format("Invalid trophy id for block entity at %s: %s", this.method_11016(), this.trophyID));
            }
        }
        if (this.method_10997() != null && this.method_10997().method_8608()) {
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        if (this.trophyID != null) {
            tag.method_10582("Trophy", this.trophyID.toString());
        }
        if (this.rewardCooldown > 0) {
            tag.method_10569("RewardCooldown", this.rewardCooldown);
        }
    }

    protected void method_57568(class_2586.class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        this.trophyID = (class_2960)dataComponentInput.method_58695((class_9331)ModDataComponents.TROPHY.get(), null);
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840((class_9331)ModDataComponents.TROPHY.get(), (Object)this.trophyID);
    }

    public void method_57569(class_2487 compoundTag) {
        compoundTag.method_10551("trophy");
    }
}

