/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_7923;
import trofers.Trofers;
import trofers.data.ConditionalTrophyDrops;

public class EntityDrops
extends ConditionalTrophyDrops {
    public static final MapCodec<EntityDrops> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> EntityDrops.codecStart(instance).and((App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)class_2960.field_25139).stable().fieldOf("trophies").forGetter(m -> m.trophies)).apply((Applicative)instance, EntityDrops::create));
    public static final Codec<EntityDrops> CODEC = MAP_CODEC.codec();
    public static final EntityDrops NONE = new EntityDrops(List.of(), class_1802.field_8162, new HashMap<class_2960, class_2960>(), new HashSet());
    private final Map<class_2960, class_2960> trophies;
    private final Set<class_1299<?>> entities;

    private EntityDrops(List<class_5341> conditions, class_1792 trophyBase, Map<class_2960, class_2960> trophies, Set<class_1299<?>> entities) {
        super(conditions, trophyBase);
        this.trophies = trophies;
        this.entities = entities;
    }

    public static EntityDrops create(List<class_5341> conditions, class_1935 trophyBase, Map<class_2960, class_2960> trophies) {
        return EntityDrops.create(conditions, trophyBase, trophies, true);
    }

    public static EntityDrops create(List<class_5341> conditions, class_1935 trophyBase, Map<class_2960, class_2960> trophies, boolean validate) {
        HashSet entities = new HashSet();
        for (class_2960 entityTypeId : trophies.keySet()) {
            if (class_7923.field_41177.method_10250(entityTypeId) || !validate) {
                entities.add((class_1299)class_7923.field_41177.method_10223(entityTypeId));
                continue;
            }
            Trofers.LOGGER.error("Skipping entity trophy drops entry for missing entity '%s'".formatted(entityTypeId));
        }
        return new EntityDrops(conditions, trophyBase.method_8389(), trophies, entities);
    }

    public void apply(Consumer<class_1799> generatedLoot, class_47 context) {
        if (this.matchesConditions(context)) {
            this.doApply(generatedLoot, context);
        }
    }

    private void doApply(Consumer<class_1799> generatedLoot, class_47 context) {
        class_1299 entityType;
        if (context.method_300(class_181.field_1226) && this.entities.contains(entityType = ((class_1297)context.method_35508(class_181.field_1226)).method_5864())) {
            class_2960 trophyId = this.trophies.get(class_7923.field_41177.method_10221((Object)entityType));
            this.awardTrophy(trophyId, generatedLoot);
        }
    }
}

