/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_156;
import trofers.data.ModCodecs;

public record ColorInfo(int base, int accent) {
    public static final ColorInfo NONE = new ColorInfo(0xFFFFFF, 0xFFFFFF);
    private static final Codec<Integer> HEX_COLOR_CODEC = Codec.STRING.comapFlatMap(string -> {
        try {
            int i = Integer.parseInt(string.substring(1), 16);
            return i >= 0 && i <= 0xFFFFFF ? DataResult.success((Object)i) : DataResult.error(() -> "Color value out of range: " + string);
        }
        catch (NumberFormatException var2) {
            return DataResult.error(() -> "Invalid color value: " + string);
        }
    }, color -> String.format("#%06X", color));
    private static final Codec<Integer> RGB_COLOR_CODEC = ModCodecs.list(ModCodecs.rangedInt(0, 255)).comapFlatMap(list -> class_156.method_33141((List)list, (int)3).map(colors -> (Integer)colors.get(0) << 16 | (Integer)colors.get(1) << 8 | (Integer)colors.get(2)), color -> List.of(Integer.valueOf(color >> 16 & 0xFF), Integer.valueOf(color >> 8 & 0xFF), Integer.valueOf(color & 0xFF)));
    private static final Codec<Integer> COLOR_CODEC = ModCodecs.withAlternative(HEX_COLOR_CODEC, RGB_COLOR_CODEC);
    public static final Codec<ColorInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.defaultField("base", 0xFFFFFF, COLOR_CODEC).forGetter(ColorInfo::base), (App)ModCodecs.defaultField("accent", 0xFFFFFF, COLOR_CODEC).forGetter(ColorInfo::accent)).apply((Applicative)instance, ColorInfo::new));
}

