/*
 * Decompiled with CFR 0.152.
 */
package com.playerbeacon.client;

import com.playerbeacon.client.PlayerBeaconConfig;
import com.playerbeacon.client.PlayerBeaconScreen;
import com.playerbeacon.client.RenderHandler;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class PlayerBeacon
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PlayerBeacon");
    private static class_304 openGuiKey;
    public static PlayerBeaconConfig config;
    public static final PlayerRoleManager roleManager;
    private static final String CONFIG_FILE = "config/playerbeacon_players.txt";
    public static BeaconMode beaconMode;

    public void onInitializeClient() {
        config = PlayerBeaconConfig.load();
        openGuiKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Open PlayerBeacon GUI", class_3675.class_307.field_1668, PlayerBeacon.config.guiOpenKey, "PlayerBeacon"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (openGuiKey.method_1436()) {
                try {
                    client.method_1507((class_437)new PlayerBeaconScreen());
                }
                catch (Throwable t) {
                    PlayerBeacon.openScreenReflective(client, new PlayerBeaconScreen());
                }
            }
        });
        WorldRenderEvents.AFTER_ENTITIES.register(ctx -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1687 == null || mc.field_1724 == null) {
                return;
            }
            class_4587 matrices = ctx.matrixStack();
            class_4597 vcp = ctx.consumers();
            class_243 cam = mc.field_1773.method_19418().method_19326();
            double camX = cam.field_1352;
            double camY = cam.field_1351;
            double camZ = cam.field_1350;
            float tickDelta = PlayerBeacon.obtainTickDelta(ctx);
            for (class_742 p : mc.field_1687.method_18456()) {
                if (p == mc.field_1724) continue;
                PlayerRole role = roleManager.getRole(PlayerBeacon.normalizeName(p.method_7334().getName()));
                RenderHandler.drawBeacon(matrices, vcp, p, role, tickDelta, camX, camY, camZ);
            }
        });
        roleManager.loadFromFile(CONFIG_FILE);
    }

    public static void cycleBeaconMode() {
        beaconMode = switch (beaconMode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> BeaconMode.NO_GRAY;
            case 1 -> BeaconMode.NO_BEACON;
            case 2 -> BeaconMode.ALL_BEACON;
        };
        LOGGER.info("PlayerBeacon: beaconMode -> {}", (Object)beaconMode);
    }

    private static float obtainTickDelta(Object ctx) {
        block33: {
            Object v2;
            Method m2;
            Object v;
            Method m;
            block32: {
                if (ctx != null) {
                    for (String name : new String[]{"tickDelta", "getTickDelta"}) {
                        try {
                            Method m3 = ctx.getClass().getMethod(name, new Class[0]);
                            Object val = m3.invoke(ctx, new Object[0]);
                            if (!(val instanceof Number)) continue;
                            return ((Number)val).floatValue();
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            LOGGER.debug("obtainTickDelta: error calling {} on ctx", (Object)name, (Object)e);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    try {
                        Method tickCounterMethod = ctx.getClass().getMethod("tickCounter", new Class[0]);
                        Object counter = tickCounterMethod.invoke(ctx, new Object[0]);
                        if (counter == null) break block32;
                        for (String mname : new String[]{"getLastTickDelta", "getTickDelta"}) {
                            try {
                                m = counter.getClass().getMethod(mname, new Class[0]);
                                v = m.invoke(counter, new Object[0]);
                                if (!(v instanceof Number)) continue;
                                return ((Number)v).floatValue();
                            }
                            catch (NoSuchMethodException ignored) {
                                if (!"getTickDelta".equals(mname)) continue;
                                try {
                                    m2 = counter.getClass().getMethod("getTickDelta", Boolean.TYPE);
                                    v2 = m2.invoke(counter, true);
                                    if (!(v2 instanceof Number)) continue;
                                    return ((Number)v2).floatValue();
                                }
                                catch (NoSuchMethodException m22) {}
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                LOGGER.debug("obtainTickDelta: error calling {} on counter", (Object)mname, (Object)e);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.debug("obtainTickDelta: error calling tickCounter on ctx", (Throwable)e);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            try {
                Method getRenderTickCounter = class_310.class.getMethod("getRenderTickCounter", new Class[0]);
                Object renderCounter = getRenderTickCounter.invoke((Object)class_310.method_1551(), new Object[0]);
                if (renderCounter == null) break block33;
                for (String mname : new String[]{"getLastTickDelta", "getTickDelta"}) {
                    try {
                        m = renderCounter.getClass().getMethod(mname, new Class[0]);
                        v = m.invoke(renderCounter, new Object[0]);
                        if (!(v instanceof Number)) continue;
                        return ((Number)v).floatValue();
                    }
                    catch (NoSuchMethodException ignored) {
                        if (!"getTickDelta".equals(mname)) continue;
                        try {
                            m2 = renderCounter.getClass().getMethod("getTickDelta", Boolean.TYPE);
                            v2 = m2.invoke(renderCounter, true);
                            if (!(v2 instanceof Number)) continue;
                            return ((Number)v2).floatValue();
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.debug("obtainTickDelta: error calling {} on renderCounter", (Object)mname, (Object)e);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.debug("obtainTickDelta: error calling MinecraftClient.getRenderTickCounter()", (Throwable)e);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        String[] possibleHolderClasses = new String[]{"net.minecraft.util.math.AnimationTickHolder", "net.minecraft.client.util.math.AnimationTickHolder", "net.minecraft.client.util.AnimationTickHolder", "net.minecraft.client.render.AnimationTickHolder"};
        String[] possibleMethods = new String[]{"getTickDelta", "getPartialTicks", "getFrameTime", "getLastTickDelta"};
        for (String clsName : possibleHolderClasses) {
            try {
                Class<?> holder = Class.forName(clsName);
                for (String methodName : possibleMethods) {
                    try {
                        Method m = holder.getMethod(methodName, new Class[0]);
                        Object val = m.invoke(null, new Object[0]);
                        if (!(val instanceof Number)) continue;
                        return ((Number)val).floatValue();
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.debug("obtainTickDelta: error calling method on holder {}", (Object)clsName, (Object)e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    private static void openScreenReflective(class_310 client, class_437 screen) {
        try {
            Method m = class_310.class.getMethod("setScreen", class_437.class);
            m.invoke((Object)client, screen);
            return;
        }
        catch (Throwable m) {
            try {
                Method m2 = class_310.class.getDeclaredMethod("setScreen", class_437.class);
                m2.setAccessible(true);
                m2.invoke((Object)client, screen);
                return;
            }
            catch (Throwable m2) {
                try {
                    client.method_1507(screen);
                }
                catch (Throwable t) {
                    LOGGER.error("Could not open screen reflectively.", t);
                }
                return;
            }
        }
    }

    public static String normalizeName(String s) {
        return s == null ? "" : s.trim().toLowerCase(Locale.ROOT);
    }

    static {
        roleManager = new PlayerRoleManager();
        beaconMode = BeaconMode.ALL_BEACON;
    }

    @Environment(value=EnvType.CLIENT)
    public static class PlayerRoleManager {
        private final Map<String, PlayerRole> roles = new ConcurrentHashMap<String, PlayerRole>();

        public PlayerRole getRole(String name) {
            return this.roles.getOrDefault(PlayerBeacon.normalizeName(name), PlayerRole.OTHER);
        }

        public void setRole(String name, PlayerRole role) {
            this.roles.put(PlayerBeacon.normalizeName(name), role);
            this.saveToFile(PlayerBeacon.CONFIG_FILE);
        }

        public void removeRole(String name) {
            this.roles.remove(PlayerBeacon.normalizeName(name));
            this.saveToFile(PlayerBeacon.CONFIG_FILE);
        }

        public void loadFromFile(String path) {
            try {
                File f = new File(path);
                if (!f.exists()) {
                    return;
                }
                for (String l : Files.readAllLines(f.toPath())) {
                    String[] p = l.split(",");
                    if (p.length != 2) continue;
                    this.roles.put(PlayerBeacon.normalizeName(p[0]), PlayerRole.valueOf(p[1]));
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load role file", (Throwable)e);
            }
        }

        public void saveToFile(String path) {
            try {
                File f = new File(path);
                File parent = f.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    LOGGER.warn("Could not create config directory: {}", (Object)parent);
                }
                ArrayList<CallSite> lines = new ArrayList<CallSite>();
                for (Map.Entry<String, PlayerRole> e : this.roles.entrySet()) {
                    lines.add((CallSite)((Object)(e.getKey() + "," + e.getValue().name())));
                }
                Files.write(f.toPath(), lines, new OpenOption[0]);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save role file", (Throwable)e);
            }
        }

        public Map<String, PlayerRole> getAll() {
            return Collections.unmodifiableMap(this.roles);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum BeaconMode {
        ALL_BEACON,
        NO_GRAY,
        NO_BEACON;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum PlayerRole {
        TEAM(-16711936),
        ALLY(-16776961),
        OTHER(-8355712),
        ENEMY_PERMANENT(-65536);

        private final int color;

        private PlayerRole(int c) {
            this.color = c;
        }

        public int getColor() {
            return this.color;
        }
    }
}

