/*
 * Decompiled with CFR 0.152.
 */
package com.playerbeacon.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Environment(value=EnvType.CLIENT)
public class PlayerBeaconConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_PATH = "config/playerbeacon_config.json";
    public int guiOpenKey = 79;

    public static PlayerBeaconConfig load() {
        PlayerBeaconConfig playerBeaconConfig;
        File file = new File(CONFIG_PATH);
        if (!file.exists()) {
            PlayerBeaconConfig config = new PlayerBeaconConfig();
            config.save();
            return config;
        }
        FileReader reader = new FileReader(file);
        try {
            playerBeaconConfig = (PlayerBeaconConfig)GSON.fromJson((Reader)reader, PlayerBeaconConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Impossible de charger la configuration PlayerBeacon, valeurs par d\u00e9faut utilis\u00e9es", (Throwable)e);
                return new PlayerBeaconConfig();
            }
        }
        reader.close();
        return playerBeaconConfig;
    }

    public void save() {
        try {
            boolean created;
            File file = new File(CONFIG_PATH);
            if (file.getParentFile() != null && !file.getParentFile().exists() && !(created = file.getParentFile().mkdirs())) {
                LOGGER.warn("Impossible de cr\u00e9er le r\u00e9pertoire de config : {}", (Object)file.getParentFile().getAbsolutePath());
            }
            try (FileWriter writer = new FileWriter(file);){
                GSON.toJson((Object)this, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LOGGER.error("Impossible de sauvegarder la configuration PlayerBeacon.", (Throwable)e);
        }
    }
}

