/*
 * Decompiled with CFR 0.152.
 */
package com.playerbeacon.client;

import com.playerbeacon.client.PlayerBeacon;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class RenderHandler {
    private static final float OFFSET_Y = 0.75f;
    private static final float SCALE = 0.25f;
    private static final class_2960 WHITE_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/misc/white.png");
    private static final int FULLBRIGHT = 0xF000F0;
    private static final double MAX_DRAW_DIST2 = 4096.0;
    private static final double SMOOTH_FACTOR = 0.35;
    private static final double SNAP_DISTANCE = 2.0;
    private static final Map<UUID, double[]> SMOOTH_POS = new ConcurrentHashMap<UUID, double[]>();
    private static final Map<Class<?>, Map<String, Optional<Field>>> FIELD_CACHE = new ConcurrentHashMap();

    public static void drawBeacon(class_4587 matrices, class_4597 vertexConsumers, class_742 player, PlayerBeacon.PlayerRole role, float tickDelta, double camX, double camY, double camZ) {
        if (PlayerBeacon.beaconMode == PlayerBeacon.BeaconMode.NO_BEACON) {
            return;
        }
        if (PlayerBeacon.beaconMode == PlayerBeacon.BeaconMode.NO_GRAY && (role == null || role == PlayerBeacon.PlayerRole.OTHER)) {
            return;
        }
        if (player == null || matrices == null || vertexConsumers == null) {
            return;
        }
        if (player.method_5767() || player.method_5715()) {
            return;
        }
        try {
            double snapSq;
            double ddz;
            double ddy;
            double dx = player.method_23317() - camX;
            double dy = player.method_23318() + (double)player.method_17682() * 0.5 - camY;
            double dz = player.method_23321() - camZ;
            if (dx * dx + dy * dy + dz * dz > 4096.0) {
                return;
            }
            OptionalDouble px = RenderHandler.tryFieldNamesDouble(player, new String[]{"lastRenderX", "prevX", "xo", "lastX"});
            OptionalDouble py = RenderHandler.tryFieldNamesDouble(player, new String[]{"lastRenderY", "prevY", "yo", "lastY"});
            OptionalDouble pz = RenderHandler.tryFieldNamesDouble(player, new String[]{"lastRenderZ", "prevZ", "zo", "lastZ"});
            double prevX = px.isPresent() ? px.getAsDouble() : player.method_23317();
            double prevY = py.isPresent() ? py.getAsDouble() : player.method_23318();
            double prevZ = pz.isPresent() ? pz.getAsDouble() : player.method_23321();
            double interpX = RenderHandler.lerp(tickDelta, prevX, player.method_23317());
            double interpY = RenderHandler.lerp(tickDelta, prevY, player.method_23318());
            double interpZ = RenderHandler.lerp(tickDelta, prevZ, player.method_23321());
            UUID pid = player.method_5667();
            double[] stored = SMOOTH_POS.computeIfAbsent(pid, k -> new double[]{interpX, interpY, interpZ});
            double ddx = interpX - stored[0];
            double dist2 = ddx * ddx + (ddy = interpY - stored[1]) * ddy + (ddz = interpZ - stored[2]) * ddz;
            if (dist2 > (snapSq = 4.0)) {
                stored[0] = interpX;
                stored[1] = interpY;
                stored[2] = interpZ;
            } else {
                stored[0] = stored[0] + (interpX - stored[0]) * 0.35;
                stored[1] = stored[1] + (interpY - stored[1]) * 0.35;
                stored[2] = stored[2] + (interpZ - stored[2]) * 0.35;
            }
            double renderX = stored[0];
            double renderY = stored[1];
            double renderZ = stored[2];
            matrices.method_22903();
            matrices.method_22904(renderX - camX, renderY + (double)player.method_17682() + 0.75 - camY, renderZ - camZ);
            matrices.method_22905(0.25f, 0.25f, 0.25f);
            class_4588 consumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)WHITE_TEXTURE));
            int mainColor = RenderHandler.resolveMainColor(role);
            int outlineColor = RenderHandler.darkenColor(mainColor);
            matrices.method_22903();
            matrices.method_22905(1.09f, 1.09f, 1.09f);
            RenderHandler.drawFilledDiamond(matrices, consumer, outlineColor);
            matrices.method_22909();
            RenderHandler.drawFilledDiamond(matrices, consumer, mainColor);
            matrices.method_22909();
        }
        catch (Throwable t) {
            PlayerBeacon.LOGGER.error("Erreur dans drawBeacon", t);
        }
    }

    private static OptionalDouble tryFieldNamesDouble(Object obj, String[] names) {
        Class<?> cls = obj.getClass();
        for (String name : names) {
            try {
                Object val;
                Object v;
                Field f = RenderHandler.findFieldCached(cls, name);
                if (f == null) continue;
                if (f.getType() == Double.TYPE) {
                    return OptionalDouble.of(f.getDouble(obj));
                }
                if (f.getType() == Float.TYPE && (v = f.get(obj)) instanceof Float) {
                    Float fv = (Float)v;
                    return OptionalDouble.of(fv.doubleValue());
                }
                if (f.getType() != Double.class || !((val = f.get(obj)) instanceof Double)) continue;
                Double d = (Double)val;
                return OptionalDouble.of(d);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return OptionalDouble.empty();
    }

    private static Field findFieldCached(Class<?> cls, String name) {
        Map inner = FIELD_CACHE.computeIfAbsent(cls, c -> new ConcurrentHashMap());
        Optional cached = (Optional)inner.get(name);
        if (cached != null) {
            return cached.orElse(null);
        }
        Field f = RenderHandler.findFieldRecursive(cls, name);
        if (f != null) {
            try {
                f.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            inner.put(name, Optional.of(f));
        } else {
            inner.put(name, Optional.empty());
        }
        return f;
    }

    private static Field findFieldRecursive(Class<?> cls, String name) {
        for (Class<?> c = cls; c != null; c = c.getSuperclass()) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    private static void drawFilledDiamond(class_4587 matrices, class_4588 consumer, int color) {
        float half = 0.6f;
        float h = 0.8f;
        float topX = 0.0f;
        float topZ = 0.0f;
        float btmX = 0.0f;
        float btmY = -0.8f;
        float btmZ = 0.0f;
        float p0y = 0.0f;
        float p0z = 0.0f;
        float p1x = 0.0f;
        float p1y = 0.0f;
        float p2x = -0.6f;
        float p2y = 0.0f;
        float p2z = 0.0f;
        float p3x = 0.0f;
        float p3y = 0.0f;
        float p3z = -0.6f;
        RenderHandler.fillTriangle(matrices, consumer, topX, 0.8f, topZ, 0.6f, p0y, p0z, p1x, p1y, 0.6f, color);
        RenderHandler.fillTriangle(matrices, consumer, topX, 0.8f, topZ, p1x, p1y, 0.6f, p2x, p2y, p2z, color);
        RenderHandler.fillTriangle(matrices, consumer, topX, 0.8f, topZ, p2x, p2y, p2z, p3x, p3y, p3z, color);
        RenderHandler.fillTriangle(matrices, consumer, topX, 0.8f, topZ, p3x, p3y, p3z, 0.6f, p0y, p0z, color);
        RenderHandler.fillTriangle(matrices, consumer, btmX, btmY, btmZ, p1x, p1y, 0.6f, 0.6f, p0y, p0z, color);
        RenderHandler.fillTriangle(matrices, consumer, btmX, btmY, btmZ, p2x, p2y, p2z, p1x, p1y, 0.6f, color);
        RenderHandler.fillTriangle(matrices, consumer, btmX, btmY, btmZ, p3x, p3y, p3z, p2x, p2y, p2z, color);
        RenderHandler.fillTriangle(matrices, consumer, btmX, btmY, btmZ, 0.6f, p0y, p0z, p3x, p3y, p3z, color);
    }

    private static void fillTriangle(class_4587 matrices, class_4588 consumer, float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, int colorArgb) {
        class_4587.class_4665 entry = matrices.method_23760();
        int color = (colorArgb & 0xFF000000) == 0 ? colorArgb | 0xFF000000 : colorArgb;
        float R = (float)(color >> 16 & 0xFF) / 255.0f;
        float G = (float)(color >> 8 & 0xFF) / 255.0f;
        float B = (float)(color & 0xFF) / 255.0f;
        float A = (float)(color >> 24 & 0xFF) / 255.0f;
        float nx = 0.0f;
        float ny = 1.0f;
        float nz = 0.0f;
        consumer.method_22918(entry.method_23761(), ax, ay, az).method_22915(R, G, B, A).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
        consumer.method_22918(entry.method_23761(), bx, by, bz).method_22915(R, G, B, A).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
        consumer.method_22918(entry.method_23761(), cx, cy, cz).method_22915(R, G, B, A).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, 0.0f, 1.0f, 0.0f);
        consumer.method_22918(entry.method_23761(), cx, cy, cz).method_22915(R, G, B, A).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, -0.0f, -1.0f, -0.0f);
        consumer.method_22918(entry.method_23761(), bx, by, bz).method_22915(R, G, B, A).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, -0.0f, -1.0f, -0.0f);
        consumer.method_22918(entry.method_23761(), ax, ay, az).method_22915(R, G, B, A).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(entry, -0.0f, -1.0f, -0.0f);
    }

    private static int resolveMainColor(PlayerBeacon.PlayerRole role) {
        if (role == null) {
            return -8355712;
        }
        return switch (role) {
            case PlayerBeacon.PlayerRole.TEAM -> -16711936;
            case PlayerBeacon.PlayerRole.ALLY -> -16776961;
            case PlayerBeacon.PlayerRole.ENEMY_PERMANENT -> -65536;
            default -> -8355712;
        };
    }

    private static int darkenColor(int color) {
        float f = 0.55f;
        int r = (int)((float)(color >> 16 & 0xFF) * f);
        int g = (int)((float)(color >> 8 & 0xFF) * f);
        int b = (int)((float)(color & 0xFF) * f);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    private static double lerp(double t, double a, double b) {
        return a + (b - a) * t;
    }
}

