/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.blocks.MossyGrimestoneBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class GrimestoneBlock
extends RotatedPillarBlock
implements BonemealableBlock {
    public GrimestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader worldIn, BlockPos pos, BlockState blockState) {
        if (worldIn.getBlockState(pos.above()).propagatesSkylightDown((BlockGetter)worldIn, pos)) {
            for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
                if (worldIn.getBlockState(blockpos).getBlock() != DDBlocks.MOSSY_GRIMESTONE.get()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBonemealSuccess(Level p_50901_, RandomSource p_50902_, BlockPos p_50903_, BlockState p_50904_) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource p_50894_, BlockPos pos, BlockState p_50896_) {
        boolean flag = false;
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-1, -1, -1), (BlockPos)pos.offset(1, 1, 1))) {
            BlockState blockstate = worldIn.getBlockState(blockpos);
            if (!blockstate.is((Block)DDBlocks.MOSSY_GRIMESTONE.get())) continue;
            flag = true;
        }
        if (flag) {
            worldIn.setBlock(pos, ((MossyGrimestoneBlock)((Object)DDBlocks.MOSSY_GRIMESTONE.get())).defaultBlockState(), 3);
        }
    }
}

