/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.blocks.CrystalMelonBlock;
import com.naterbobber.darkerdepths.blocks.DeadLivingCrystalBlock;
import com.naterbobber.darkerdepths.blocks.StoneMelonBlock;
import com.naterbobber.darkerdepths.init.DDBlockStateProperties;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LivingCrystalBlock
extends Block {
    public LivingCrystalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos blockPos, RandomSource random) {
        if (random.nextInt(5) != 0) {
            return;
        }
        BlockPos blockpos = blockPos.relative(Direction.getRandom((RandomSource)random));
        BlockState blockstate = level.getBlockState(blockpos);
        BlockState block = null;
        if (blockstate.is(BlockTags.DIAMOND_ORES)) {
            block = (BlockState)((DeadLivingCrystalBlock)((Object)DDBlocks.DEAD_LIVING_CRYSTAL.get())).defaultBlockState().setValue((Property)DDBlockStateProperties.CRYSTAL_GROWTH_LEVEL, (Comparable)Integer.valueOf(1));
            level.playSound(null, blockpos, SoundEvents.AMETHYST_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(2001, blockpos, LivingCrystalBlock.getId((BlockState)blockstate));
        } else if (blockstate.is(Blocks.MELON)) {
            block = ((StoneMelonBlock)((Object)DDBlocks.STONE_MELON.get())).defaultBlockState();
        } else if (blockstate.is((Block)DDBlocks.STONE_MELON.get())) {
            int stoneMelonGrowthLevel = (Integer)blockstate.getValue((Property)DDBlockStateProperties.MELON_GROWTH_LEVEL);
            if (stoneMelonGrowthLevel >= 2) {
                block = ((CrystalMelonBlock)((Object)DDBlocks.CRYSTAL_MELON.get())).defaultBlockState();
                level.setBlock(blockPos, ((DeadLivingCrystalBlock)((Object)DDBlocks.DEAD_LIVING_CRYSTAL.get())).defaultBlockState(), 2);
            } else {
                block = (BlockState)blockstate.setValue((Property)DDBlockStateProperties.MELON_GROWTH_LEVEL, (Comparable)Integer.valueOf(stoneMelonGrowthLevel + 1));
            }
            level.playSound(null, blockpos, SoundEvents.AMETHYST_BLOCK_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.levelEvent(2001, blockpos, LivingCrystalBlock.getId((BlockState)blockstate));
        }
        if (block != null) {
            level.setBlockAndUpdate(blockpos, block);
        }
    }
}

