/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class PorousBlock
extends RotatedPillarBlock {
    public PorousBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        Direction direction;
        BlockPos blockPos;
        BlockState blockState;
        if (random.nextInt(17) == 0 && PorousBlock.canGrowIn(blockState = worldIn.getBlockState(blockPos = pos.relative(direction = Direction.getRandom((RandomSource)random)))) && direction != Direction.UP) {
            worldIn.setBlockAndUpdate(blockPos, (BlockState)((BlockState)((AmethystClusterBlock)DDBlocks.AMBER_CLUSTER.get()).defaultBlockState().setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction)).setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(blockState.getFluidState().getType() == Fluids.WATER)));
        }
    }

    public static boolean canGrowIn(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) && state.getFluidState().getAmount() == 8;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        Direction direction;
        if (rand.nextInt(10) == 0 && (direction = Direction.getRandom((RandomSource)rand)) != Direction.UP) {
            BlockPos blockPos = pos.relative(direction);
            BlockState blockState = worldIn.getBlockState(blockPos);
            if (!stateIn.canOcclude() || !blockState.isFaceSturdy((BlockGetter)worldIn, blockPos, direction.getOpposite())) {
                double x = direction.getStepX() == 0 ? rand.nextDouble() : 0.5 + (double)direction.getStepX() * 0.6;
                double y = direction.getStepY() == 0 ? rand.nextDouble() : 0.5 + (double)direction.getStepY() * 0.6;
                double z = direction.getStepZ() == 0 ? rand.nextDouble() : 0.5 + (double)direction.getStepZ() * 0.6;
                worldIn.addParticle((ParticleOptions)DDParticleTypes.DRIPPING_AMBER.get(), (double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z, 0.0, 0.0, 0.0);
            }
        }
    }
}

