/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.create((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        rot = rot.getRotated(Rotation.CLOCKWISE_180);
        return state.getValue(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(rot.rotate(((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).direction))));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.getValue(TYPE) == VerticalSlabType.DOUBLE ? state : (BlockState)state.setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).direction.getOpposite())));
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, WATERLOGGED});
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((VerticalSlabType)((Object)state.getValue(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.getBlock() == this) {
            return (BlockState)((BlockState)blockstate.setValue(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluid = context.getLevel().getFluidState(blockpos);
        BlockState retState = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.getType() == Fluids.WATER));
        Direction direction = this.getDirectionForPlacement(context);
        VerticalSlabType type = VerticalSlabType.fromDirection(direction);
        return (BlockState)retState.setValue(TYPE, (Comparable)((Object)type));
    }

    private Direction getDirectionForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        if (direction.getAxis() != Direction.Axis.Y) {
            return direction;
        }
        BlockPos pos = context.getClickedPos();
        Vec3 vec = context.getClickLocation().subtract(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())).subtract(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.x, vec.z) * -180.0 / Math.PI;
        return Direction.fromYRot((double)angle).getOpposite();
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        VerticalSlabType slabType = (VerticalSlabType)((Object)state.getValue(TYPE));
        return slabType != VerticalSlabType.DOUBLE && stack.getItem() == this.asItem() && (context.replacingClickedOnBlock() && context.getClickedFace() == slabType.direction && this.getDirectionForPlacement(context) == slabType.direction || !context.replacingClickedOnBlock() && context.getClickedFace().getAxis() != slabType.direction.getAxis());
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(LevelAccessor worldIn, @Nonnull BlockPos pos, BlockState state, @Nonnull FluidState fluidStateIn) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.placeLiquid(worldIn, pos, state, fluidStateIn);
    }

    public boolean canPlaceLiquid(Player player, BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.canPlaceLiquid(player, worldIn, pos, state, fluidIn);
    }

    public BlockState updateShape(BlockState stateIn, Direction p_60542_, BlockState p_60543_, LevelAccessor worldIn, BlockPos currentPos, BlockPos p_60546_) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, p_60542_, p_60543_, worldIn, currentPos, p_60546_);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return type == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    public static enum VerticalSlabType implements StringRepresentable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.name = direction == null ? "double" : direction.getName();
            this.direction = direction;
            if (direction == null) {
                this.shape = Shapes.block();
            } else {
                double min = 0.0;
                double max = 8.0;
                if (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) {
                    min = 8.0;
                    max = 16.0;
                }
                this.shape = direction.getAxis() == Direction.Axis.X ? Block.box((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.box((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public String toString() {
            return this.name;
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

