/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientDeathAnchorAnimationOverlay {
    private static boolean isOverlayActive = false;
    private static int currentFrame = 1;
    private static int startFrame = 1;
    private static long lastFrameTime = 0L;
    public static final int FRAME_COUNT = 200;
    private static final int FRAME_DURATION_MS = 50;
    public static final List<ResourceLocation> ANIMATION_FRAMES = new ArrayList<ResourceLocation>();

    @SubscribeEvent
    public void onRenderGuiOverlay(RenderGuiLayerEvent.Post event) {
        if (!isOverlayActive) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        ClientDeathAnchorAnimationOverlay.updateAnimation();
        ClientDeathAnchorAnimationOverlay.renderOverlay(guiGraphics, screenWidth, screenHeight);
    }

    private static void updateAnimation() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        if (mc.screen instanceof DeathScreen) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFrameTime >= 50L) {
            if (currentFrame < ANIMATION_FRAMES.size() - 1) {
                ++currentFrame;
                lastFrameTime = currentTime;
            } else if (currentTime - lastFrameTime >= 100L) {
                ClientDeathAnchorAnimationOverlay.stopOverlay();
            }
        }
    }

    private static void renderOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ClientDeathAnchorAnimationOverlay.renderTexturedOverlay(guiGraphics, screenWidth, screenHeight);
        RenderSystem.disableBlend();
        poseStack.popPose();
    }

    private static void renderTexturedOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (ANIMATION_FRAMES.isEmpty()) {
            return;
        }
        ResourceLocation currentTexture = ANIMATION_FRAMES.get(currentFrame);
        guiGraphics.blit(currentTexture, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void startOverlay() {
        isOverlayActive = true;
        currentFrame = startFrame = 0;
        lastFrameTime = System.currentTimeMillis();
    }

    public static void stopOverlay() {
        isOverlayActive = false;
        currentFrame = 0;
    }

    public static boolean isOverlayActive() {
        return isOverlayActive;
    }

    public static int getCurrentFrame() {
        return currentFrame;
    }

    public static void setFrame(int frame) {
        if (frame >= 0 && frame < ANIMATION_FRAMES.size()) {
            currentFrame = frame;
        }
    }

    static {
        for (int i = startFrame; i <= 200; ++i) {
            ResourceLocation frameLocation = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)("textures/gui/death_anchor_overlay/frame_" + i + ".png"));
            ANIMATION_FRAMES.add(frameLocation);
        }
    }
}

