/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.models;

import com.naterbobber.darkerdepths.DarkerDepths;
import com.naterbobber.darkerdepths.entities.BodySnatcherEntity;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

@OnlyIn(value=Dist.CLIENT)
public class BodySnatcherModel
extends DefaultedEntityGeoModel<BodySnatcherEntity> {
    public BodySnatcherModel() {
        super(ResourceLocation.withDefaultNamespace((String)"darkerdepths"), true);
    }

    public ResourceLocation getModelResource(BodySnatcherEntity bodySnatcherEntity) {
        return DarkerDepths.id("geo/entity/body_snatcher.geo.json");
    }

    public ResourceLocation getTextureResource(BodySnatcherEntity bodySnatcherEntity) {
        return DarkerDepths.id("textures/entity/body_snatcher/body_snatcher.png");
    }

    public ResourceLocation getAnimationResource(BodySnatcherEntity bodySnatcherEntity) {
        return DarkerDepths.id("animations/entity/body_snatcher.animation.json");
    }

    public void setCustomAnimations(BodySnatcherEntity animatable, long instanceId, AnimationState<BodySnatcherEntity> animationState) {
        if (this.getBone("head").isEmpty() || this.headBone == null) {
            return;
        }
        GeoBone head = this.getAnimationProcessor().getBone(this.headBone);
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(((GeoBone)this.getBone("head").get()).getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(((GeoBone)this.getBone("head").get()).getRotY() + entityData.netHeadYaw() * ((float)Math.PI / 180));
        if (this.getBone("body").isPresent()) {
            GeoBone body = (GeoBone)this.getBone("body").get();
            head.setPosY(body.getPosY() + 0.7f);
            head.setPosX(body.getPosX());
            head.setPosZ(body.getPosZ());
        }
    }
}

