/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.data;

import com.naterbobber.darkerdepths.data.DDDatapackBuiltinEntriesProvider;
import com.naterbobber.darkerdepths.data.DDRecipeProvider;
import com.naterbobber.darkerdepths.data.assets.DDBlockStateProvider;
import com.naterbobber.darkerdepths.data.assets.DDLanguageProviderENUS;
import com.naterbobber.darkerdepths.data.loot.DDLootTableProvider;
import com.naterbobber.darkerdepths.data.tags.DDBiomeTagsProvider;
import com.naterbobber.darkerdepths.data.tags.DDBlockTagsProvider;
import com.naterbobber.darkerdepths.data.tags.DDDamageTypeTagsProvider;
import com.naterbobber.darkerdepths.data.tags.DDItemTagsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="darkerdepths")
public class DDDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator dataGenerator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput packOutput = dataGenerator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        dataGenerator.addProvider(client, (DataProvider)new DDBlockStateProvider(packOutput, existingFileHelper));
        dataGenerator.addProvider(client, (DataProvider)new DDLanguageProviderENUS(packOutput));
        dataGenerator.addProvider(server, (DataProvider)new DDRecipeProvider(packOutput, lookupProvider));
        dataGenerator.addProvider(server, (DataProvider)new DDLootTableProvider(packOutput, lookupProvider));
        DDBlockTagsProvider blockTagsProvider = (DDBlockTagsProvider)dataGenerator.addProvider(server, (DataProvider)new DDBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        dataGenerator.addProvider(server, (DataProvider)new DDItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        dataGenerator.addProvider(server, (DataProvider)new DDBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        dataGenerator.addProvider(server, (DataProvider)new DDDamageTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        dataGenerator.addProvider(server, (DataProvider)new DDDatapackBuiltinEntriesProvider(packOutput, lookupProvider));
    }
}

