/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.blocks.LayeredDeepslateBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.world.gen.features.config.CorrespondentLayersConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class CorrespondentLayersFeature
extends Feature<CorrespondentLayersConfig> {
    public CorrespondentLayersFeature(Codec<CorrespondentLayersConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<CorrespondentLayersConfig> context) {
        WorldGenLevel worldgenlevel = context.level();
        CorrespondentLayersConfig config = (CorrespondentLayersConfig)context.config();
        RandomSource random = context.random();
        BlockPos blockpos = context.origin();
        Predicate<BlockState> predicate = state -> state.is(config.replaceable);
        int i = config.xzRadius.sample(random) + 1;
        int j = config.xzRadius.sample(random) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, config, random, blockpos, predicate, i, j);
        this.distributeVegetation(context, worldgenlevel, config, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel world, CorrespondentLayersConfig config, RandomSource random, BlockPos pos, Predicate<BlockState> predicate, int xRadius, int zRadius) {
        BlockPos.MutableBlockPos mut = pos.mutable();
        BlockPos.MutableBlockPos mut1 = mut.mutable();
        Direction direction = config.surface.getDirection();
        Direction direction1 = direction.getOpposite();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -xRadius; i <= xRadius; ++i) {
            boolean flag = i == -xRadius || i == xRadius;
            for (int j = -zRadius; j <= zRadius; ++j) {
                boolean flag4;
                boolean flag1 = j == -zRadius || j == zRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.extraEdgeColumnChance == 0.0f || random.nextFloat() > config.extraEdgeColumnChance)) continue;
                mut.setWithOffset((Vec3i)pos, i, 0, j);
                for (int k = 0; world.isStateAtPosition((BlockPos)mut, DripstoneUtils::isEmptyOrWater) && k < config.verticalRange; ++k) {
                    mut.move(direction);
                }
                for (int i1 = 0; world.isStateAtPosition((BlockPos)mut, state -> !DripstoneUtils.isEmptyOrWater((BlockState)state)) && i1 < config.verticalRange; ++i1) {
                    mut.move(direction1);
                }
                mut1.setWithOffset((Vec3i)mut, config.surface.getDirection());
                BlockState blockstate = world.getBlockState((BlockPos)mut1);
                if (!world.isStateAtPosition((BlockPos)mut, DripstoneUtils::isEmptyOrWater) || !blockstate.isFaceSturdy((BlockGetter)world, (BlockPos)mut1, config.surface.getDirection().getOpposite())) continue;
                int l = config.depth.sample(random) + (config.extraBottomBlockChance > 0.0f && random.nextFloat() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos blockpos = mut1.immutable();
                boolean flag5 = this.placeGround(world, config, predicate, random, mut1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
        return set;
    }

    protected void distributeVegetation(FeaturePlaceContext<CorrespondentLayersConfig> context, WorldGenLevel world, CorrespondentLayersConfig config, RandomSource random, Set<BlockPos> pos, int p_160619_, int p_160620_) {
        for (BlockPos blockpos : pos) {
            if (!(config.vegetationChance > 0.0f) || !(random.nextFloat() < config.vegetationChance)) continue;
            this.placeVegetation(world, config, context.chunkGenerator(), random, blockpos);
        }
    }

    protected boolean placeVegetation(WorldGenLevel world, CorrespondentLayersConfig config, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        if (world.isStateAtPosition(pos.relative(config.surface.getDirection().getOpposite()), BlockBehaviour.BlockStateBase::isAir) && world.getBlockState(pos).is(config.layers.get(0).getState(random, pos).getBlock())) {
            return ((PlacedFeature)config.vegetationFeature.value()).place(world, generator, random, pos.relative(config.surface.getDirection().getOpposite()));
        }
        return false;
    }

    protected boolean placeGround(WorldGenLevel world, CorrespondentLayersConfig config, Predicate<BlockState> predicate, RandomSource random, BlockPos.MutableBlockPos pos, int tries) {
        for (int i = 0; i < tries; ++i) {
            BlockState blockstate = config.layers.get(0).getState(random, (BlockPos)pos);
            BlockState belowState = config.layers.get(1).getState(random, (BlockPos)pos);
            BlockState posBelow = world.getBlockState(pos.below());
            if (blockstate == ((RotatedPillarBlock)DDBlocks.ARIDROCK.get()).defaultBlockState() && (world.getBlockState((BlockPos)pos).is((Block)DDBlocks.DUSKROCK.get()) || posBelow.is((Block)DDBlocks.DUSKROCK.get()))) continue;
            if (blockstate == ((RotatedPillarBlock)DDBlocks.ARIDROCK.get()).defaultBlockState() && !posBelow.is(Blocks.DEEPSLATE) && !posBelow.is(Blocks.TUFF)) {
                belowState = ((RotatedPillarBlock)DDBlocks.ARIDROCK.get()).defaultBlockState();
            }
            if (posBelow.is(Blocks.TUFF) || posBelow.is(Blocks.DEEPSLATE)) {
                world.setBlock(pos.below(), belowState, 2);
                world.setBlock((BlockPos)pos, blockstate, 2);
                if (!config.xzReplace) continue;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (world.getBlockState(pos.relative(direction)).is(Blocks.DEEPSLATE) && world.getBlockState(pos.relative(direction).above()).canBeReplaced()) {
                        world.setBlock(pos.relative(direction), ((LayeredDeepslateBlock)((Object)DDBlocks.ARID_DEEPSLATE.get())).defaultBlockState(), 2);
                        continue;
                    }
                    if (!world.getBlockState(pos.below().relative(direction)).is(Blocks.DEEPSLATE) || !world.getBlockState(pos.relative(direction)).canBeReplaced()) continue;
                    world.setBlock(pos.below().relative(direction), ((RotatedPillarBlock)DDBlocks.ARIDROCK.get()).defaultBlockState(), 2);
                }
                continue;
            }
            if (!posBelow.is(BlockTags.BASE_STONE_OVERWORLD)) continue;
            belowState = belowState.is((Block)DDBlocks.ARID_DEEPSLATE.get()) ? ((RotatedPillarBlock)DDBlocks.ARIDROCK.get()).defaultBlockState() : belowState;
            world.setBlock(pos.below(), belowState, 2);
            world.setBlock((BlockPos)pos, blockstate, 2);
        }
        return true;
    }
}

