/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.blocks.PetrifiedRootBlock;
import com.naterbobber.darkerdepths.blocks.PetrifiedRootPlantBlock;
import com.naterbobber.darkerdepths.blocks.PorousBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.world.gen.features.config.PetrifiedBranchConfig;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluids;

public class PetrifiedBranchFeature
extends Feature<PetrifiedBranchConfig> {
    public PetrifiedBranchFeature(Codec<PetrifiedBranchConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<PetrifiedBranchConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        PetrifiedBranchConfig config = (PetrifiedBranchConfig)context.config();
        if (!world.isEmptyBlock(pos) || !world.getBlockState(pos.above()).is(BlockTags.BASE_STONE_OVERWORLD)) {
            return false;
        }
        boolean flag = false;
        ArrayList woodPos = Lists.newArrayList();
        ArrayList porousPos = Lists.newArrayList();
        int height = UniformInt.of((int)config.minLength(), (int)config.maxLength()).sample(random);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= height; ++y) {
                    BlockState state;
                    BlockPos blockPos = new BlockPos(pos.getX() + x, pos.getY() - y, pos.getZ() + z);
                    BlockState blockState = state = random.nextBoolean() && random.nextInt(10) == 0 ? ((PorousBlock)((Object)DDBlocks.POROUS_PETRIFIED_LOG.get())).defaultBlockState() : ((RotatedPillarBlock)DDBlocks.PETRIFIED_LOG.get()).defaultBlockState();
                    if (random.nextInt(3) != 0) continue;
                    if (state.is((Block)DDBlocks.POROUS_PETRIFIED_LOG.get())) {
                        porousPos.add(blockPos);
                    }
                    if (world.isStateAtPosition(blockPos, DripstoneUtils::isEmptyOrWaterOrLava)) {
                        world.setBlock(blockPos, state, 2);
                        woodPos.add(blockPos);
                    }
                    flag = true;
                }
            }
        }
        for (BlockPos blockPos : woodPos) {
            if (world.getFluidState(blockPos.below()).isEmpty() && world.getFluidState(blockPos.below(2)).isEmpty() && world.getBlockState(blockPos.below(2)).canBeReplaced() && world.getBlockState(blockPos.below()).canBeReplaced()) {
                world.setBlock(blockPos.below(), ((PetrifiedRootPlantBlock)((Object)DDBlocks.PETRIFIED_ROOTS_PLANT.get())).defaultBlockState(), 2);
                world.setBlock(blockPos.below(2), ((PetrifiedRootBlock)((Object)DDBlocks.PETRIFIED_ROOTS.get())).defaultBlockState(), 2);
                continue;
            }
            if (world.getFluidState(blockPos.below()).isEmpty() && world.getBlockState(blockPos.below()).canBeReplaced() && (!world.getBlockState(blockPos.below(2)).is((Block)DDBlocks.PETRIFIED_LOG.get()) || world.isEmptyBlock(blockPos.below(2)))) {
                world.setBlock(blockPos.below(), ((PetrifiedRootBlock)((Object)DDBlocks.PETRIFIED_ROOTS.get())).defaultBlockState(), 2);
                continue;
            }
            if (!world.getFluidState(blockPos.below()).isEmpty() || !world.getBlockState(blockPos.below()).canBeReplaced() || !world.getBlockState(blockPos.below(2)).is((Block)DDBlocks.PETRIFIED_LOG.get())) continue;
            world.setBlock(blockPos.below(), ((PetrifiedRootPlantBlock)((Object)DDBlocks.PETRIFIED_ROOTS_PLANT.get())).defaultBlockState(), 2);
        }
        if (flag && random.nextInt(5) == 0) {
            for (Direction direction : Direction.values()) {
                for (BlockPos blockPos : porousPos) {
                    if (!random.nextBoolean() || !world.isStateAtPosition(blockPos.relative(direction), DripstoneUtils::isEmptyOrWater)) continue;
                    world.setBlock(blockPos.relative(direction), (BlockState)((BlockState)((AmethystClusterBlock)DDBlocks.AMBER_CLUSTER.get()).defaultBlockState().setValue((Property)AmethystClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockPos.relative(direction)).getType() == Fluids.WATER))).setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction), 2);
                }
            }
        }
        return flag;
    }
}

