/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.processors.catacombs;

import com.mojang.serialization.MapCodec;
import com.naterbobber.darkerdepths.blocks.TombBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDStructureProcessorTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class TombProcessor
extends StructureProcessor {
    public static final MapCodec<TombProcessor> CODEC = MapCodec.unit(TombProcessor::new);
    private final Map<BlockPos, StructureTemplate.StructureBlockInfo> tombPartsMap = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos templatePos, BlockPos worldPos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockState blockState = relativeBlockInfo.state();
        if (blockState.is(Blocks.MAGENTA_GLAZED_TERRACOTTA)) {
            Direction facing = this.getFacingDirection(blockState, settings);
            Set<StructureTemplate.StructureBlockInfo> currentTombPartsSet = TombBlock.generateMultiblockForProcessor(worldPos, facing, level, relativeBlockInfo.pos());
            HashMap currentTombParts = new HashMap();
            currentTombPartsSet.forEach(part -> currentTombParts.put(part.pos(), part));
            this.tombPartsMap.putAll(currentTombParts);
            BlockState tombState = (BlockState)((BlockState)((BlockState)((BlockState)((TombBlock)((Object)DDBlocks.TOMB.get())).defaultBlockState().setValue(TombBlock.PART, (Comparable)((Object)TombBlock.Part.FRONT_CENTER))).setValue((Property)TombBlock.FACING, (Comparable)facing)).setValue((Property)TombBlock.INHABITED, (Comparable)Boolean.valueOf(true))).setValue((Property)TombBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(worldPos).getType() == Fluids.WATER));
            CompoundTag nbt = new CompoundTag();
            ListTag itemsNbt = new ListTag();
            ItemStack forsakenBronzeScrap = new ItemStack((ItemLike)DDItems.FORSAKEN_BRONZE_SCRAP.get());
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)0);
            forsakenBronzeScrap.save((HolderLookup.Provider)level.registryAccess());
            itemsNbt.add((Object)itemTag);
            nbt.put("Items", (Tag)itemsNbt);
            return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), tombState, nbt);
        }
        StructureTemplate.StructureBlockInfo tombPart = this.tombPartsMap.get(relativeBlockInfo.pos());
        if (tombPart != null) {
            return tombPart;
        }
        return relativeBlockInfo;
    }

    private Direction getFacingDirection(BlockState markerBlock, StructurePlaceSettings settings) {
        if (markerBlock.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction markerFacing = (Direction)markerBlock.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return settings.getRotation().rotate(markerFacing);
        }
        return settings.getRotation().rotate(Direction.NORTH);
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)DDStructureProcessorTypes.TOMB.get();
    }
}

