/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.blocks.GlowshroomBlock;
import com.naterbobber.darkerdepths.blocks.GrimestoneBlock;
import com.naterbobber.darkerdepths.blocks.SproutsBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import net.neoforged.neoforge.common.util.TriState;

public class MossyGrimestoneBlock
extends Block
implements BonemealableBlock {
    public MossyGrimestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private static boolean isDarkEnough(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos above = pos.above();
        BlockState aboveState = world.getBlockState(above);
        int lightLevel = LightEngine.getLightBlockInto((BlockGetter)world, (BlockState)state, (BlockPos)pos, (BlockState)aboveState, (BlockPos)above, (Direction)Direction.UP, (int)aboveState.getLightBlock((BlockGetter)world, above));
        return lightLevel < world.getMaxLightLevel();
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        if (!MossyGrimestoneBlock.isDarkEnough(state, (LevelReader)worldIn, pos)) {
            worldIn.setBlockAndUpdate(pos, ((GrimestoneBlock)((Object)DDBlocks.GRIMESTONE.get())).defaultBlockState());
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return levelReader.getBlockState(blockPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level worldIn, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = ((MossyGrimestoneBlock)((Object)DDBlocks.MOSSY_GRIMESTONE.get())).defaultBlockState();
        block0: for (int range = 0; range < 128; ++range) {
            BlockState blockstate1;
            BlockPos blockpos1 = blockpos;
            for (int tries = 0; tries < range / 16; ++tries) {
                if (!worldIn.getBlockState((blockpos1 = blockpos1.offset(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).below()).is((Block)this) || worldIn.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)worldIn, blockpos1)) continue block0;
            }
            BlockState blockstate2 = worldIn.getBlockState(blockpos1);
            if (blockstate2.is(blockstate.getBlock()) && rand.nextInt(10) == 0) {
                ((BonemealableBlock)blockstate.getBlock()).performBonemeal(worldIn, rand, blockpos1, blockstate2);
            }
            if (!blockstate2.isAir() || !(blockstate1 = rand.nextInt(10) == 0 ? (BlockState)((GlowshroomBlock)((Object)DDBlocks.GLOWSHROOM.get())).defaultBlockState().setValue((Property)GlowshroomBlock.CLUSTERS_1_3, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)rand, (int)1, (int)3))) : ((SproutsBlock)((Object)DDBlocks.MOSSY_SPROUTS.get())).defaultBlockState()).canSurvive((LevelReader)worldIn, blockpos1)) continue;
            worldIn.setBlock(blockpos1, blockstate1, 3);
        }
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return TriState.TRUE;
    }
}

