/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.mojang.serialization.MapCodec;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PetrifiedRootBlock
extends GrowingPlantHeadBlock {
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public PetrifiedRootBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.DOWN, SHAPE, false, 0.1);
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return null;
    }

    public boolean isRandomlyTicking(BlockState p_53961_) {
        return false;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext ctx) {
        Vec3 vec3 = blockState.getOffset(blockGetter, blockPos);
        return super.getShape(blockState, blockGetter, blockPos, ctx).move(vec3.x, 0.0, vec3.z);
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)randomSource);
    }

    protected boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    protected Block getBodyBlock() {
        return (Block)DDBlocks.PETRIFIED_ROOTS_PLANT.get();
    }
}

