/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RopeBlock
extends Block
implements BucketPickup,
LiquidBlockContainer {
    public static final EnumProperty<RopePart> PART = EnumProperty.create((String)"part", RopePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)RopePart.MIDDLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        if (state.getValue(PART) == RopePart.BOTTOM) {
            return Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        }
        if (state.getValue(PART) == RopePart.MIDDLE) {
            return Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        }
        return Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)13.0), Block.box((double)7.0, (double)12.0, (double)3.0, (double)9.0, (double)16.0, (double)5.0), Block.box((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)11.0)});
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return (worldIn.getBlockState(pos.above()).isFaceSturdy((BlockGetter)worldIn, pos, Direction.DOWN) || worldIn.getBlockState(pos.above()).getBlock() instanceof RopeBlock) && !(worldIn.getBlockState(pos.above()).getBlock() instanceof AirBlock);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean water = context.getLevel().getBlockState(context.getClickedPos()).getBlock() == Blocks.WATER;
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            if (this.isRopeBottom((LevelAccessor)context.getLevel(), context.getClickedPos())) {
                state = (BlockState)state.setValue(PART, (Comparable)((Object)RopePart.BOTTOM));
            } else if (this.isRopeTop((LevelAccessor)context.getLevel(), context.getClickedPos())) {
                state = (BlockState)state.setValue(PART, (Comparable)((Object)RopePart.TOP));
            }
        } else {
            return null;
        }
        return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.scheduleTick(currentPos, (Block)this, 1);
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        stateIn = this.isRopeBottom(worldIn, currentPos) ? (BlockState)stateIn.setValue(PART, (Comparable)((Object)RopePart.BOTTOM)) : (this.isRopeTop(worldIn, currentPos) ? (BlockState)stateIn.setValue(PART, (Comparable)((Object)RopePart.TOP)) : (BlockState)stateIn.setValue(PART, (Comparable)((Object)RopePart.MIDDLE)));
        return this.canSurvive(stateIn, (LevelReader)worldIn, currentPos) ? super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos) : Blocks.AIR.defaultBlockState();
    }

    public boolean isRopeBottom(LevelAccessor world, BlockPos pos) {
        return !(world.getBlockState(pos.below()).getBlock() instanceof RopeBlock);
    }

    public boolean isRopeTop(LevelAccessor world, BlockPos pos) {
        return !(world.getBlockState(pos.above()).getBlock() instanceof RopeBlock);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public ItemStack pickupBlock(Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.empty();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canPlaceLiquid(Player player, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid == Fluids.WATER;
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (fluidState.getType() == Fluids.WATER) {
            if (!world.isClientSide()) {
                world.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, WATERLOGGED});
    }

    public RenderShape getRenderShape(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    public static enum RopePart implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private RopePart(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

