/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.particle;

import com.naterbobber.darkerdepths.init.DDParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrippingParticle
extends TextureSheetParticle {
    private final Fluid fluid;
    protected boolean fullBright;

    public DrippingParticle(ClientLevel p_108323_, double p_108324_, double p_108325_, double p_108326_, Fluid fluid) {
        super(p_108323_, p_108324_, p_108325_, p_108326_);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.fluid = fluid;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected int getLightColor(float p_107249_) {
        return this.fullBright ? 240 : super.getLightColor(p_107249_);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.ageParticle();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.updateMotion();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
                FluidState fluidstate = this.level.getFluidState(blockpos);
                if (fluidstate.getType() == this.fluid && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight((BlockGetter)this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    protected void ageParticle() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void updateMotion() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LandingAmberFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public LandingAmberFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Landing landing = new Landing(worldIn, x, y, z, Fluids.EMPTY);
            landing.fullBright = true;
            ((DrippingParticle)landing).lifetime = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            landing.setColor(0.97f, 0.56f, 0.22f);
            landing.pickSprite(this.spriteSet);
            return landing;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingAmberFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public FallingAmberFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquid falling = new FallingLiquid(worldIn, x, y, z, Fluids.EMPTY, (ParticleOptions)DDParticleTypes.LANDING_AMBER.get());
            falling.fullBright = true;
            ((DrippingParticle)falling).gravity = 0.01f;
            falling.setColor(0.97f, 0.56f, 0.22f);
            falling.pickSprite(this.spriteSet);
            return falling;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DrippingAmberFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public DrippingAmberFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripping = new Dripping(worldIn, x, y, z, Fluids.EMPTY, (ParticleOptions)DDParticleTypes.FALLING_AMBER.get());
            dripping.fullBright = true;
            ((DrippingParticle)dripping).gravity *= 0.01f;
            ((DrippingParticle)dripping).lifetime = 100;
            dripping.setColor(0.97f, 0.56f, 0.22f);
            dripping.pickSprite(this.spriteSet);
            return dripping;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Landing
    extends DrippingParticle {
        private Landing(ClientLevel world, double x, double y, double z, Fluid fluid) {
            super(world, x, y, z, fluid);
            this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Falling
    extends DrippingParticle {
        Falling(ClientLevel world, double x, double y, double z, Fluid fluid) {
            this(world, x, y, z, fluid, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        Falling(ClientLevel world, double x, double y, double z, Fluid fluid, int lifetime) {
            super(world, x, y, z, fluid);
            this.lifetime = lifetime;
        }

        @Override
        protected void updateMotion() {
            if (this.onGround) {
                this.remove();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingLiquid
    extends Falling {
        protected final ParticleOptions nextParticle;

        FallingLiquid(ClientLevel world, double x, double y, double z, Fluid fluid, ParticleOptions nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
        }

        @Override
        protected void updateMotion() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.nextParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Dripping
    extends DrippingParticle {
        protected final ParticleOptions nextParticle;

        Dripping(ClientLevel world, double x, double y, double z, Fluid fluid, ParticleOptions nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
            this.gravity *= 0.02f;
            this.lifetime = 40;
        }

        @Override
        protected void ageParticle() {
            if (this.lifetime-- <= 0) {
                this.remove();
                this.level.addParticle(this.nextParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }

        @Override
        protected void updateMotion() {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }
}

