/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.particle;

import com.naterbobber.darkerdepths.init.DDParticleTypes;
import java.util.List;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VoidSoulParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final float originalScale;
    private float rotation;
    private int lingeringTime;
    private boolean canBeBottled;

    protected VoidSoulParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.lingeringTime = this.lifetime = 1200;
        this.canBeBottled = true;
        this.originalScale = this.quadSize = 0.3f + RANDOM.nextFloat() * 0.2f;
        this.friction = 0.98f;
        this.gravity = -0.001f;
        this.hasPhysics = true;
    }

    public void tick() {
        super.tick();
        double time = (double)(this.lifetime - this.age) / (double)this.lifetime;
        this.yd += Math.sin((double)this.age * 0.1) * 0.001;
        this.xd += (RANDOM.nextDouble() - 0.5) * 0.001;
        this.zd += (RANDOM.nextDouble() - 0.5) * 0.001;
        float pulse = 1.0f + (float)Math.sin((double)this.age * 0.2) * 0.1f;
        this.quadSize = this.originalScale * pulse;
        if ((float)this.age > (float)this.lifetime * 0.8f) {
            this.alpha = (float)(this.lifetime - this.age) / ((float)this.lifetime * 0.2f) * 0.8f;
        }
        this.checkForBottleInteraction();
    }

    private void checkForBottleInteraction() {
        if (!this.canBeBottled) {
            return;
        }
        List nearbyPlayers = this.level.getEntitiesOfClass(Player.class, new AABB(this.x - 2.0, this.y - 2.0, this.z - 2.0, this.x + 2.0, this.y + 2.0, this.z + 2.0));
        for (Player player : nearbyPlayers) {
            double distance;
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.getItem() != Items.GLASS_BOTTLE || !((distance = player.distanceToSqr(this.x, this.y, this.z)) < 4.0)) continue;
            this.captureInBottle(player, heldItem);
            return;
        }
    }

    private void captureInBottle(Player player, ItemStack bottleStack) {
        if (player.level().isClientSide) {
            return;
        }
        bottleStack.shrink(1);
        this.remove();
        player.level().playSound(null, player.blockPosition(), SoundEvents.BOTTLE_FILL, SoundSource.PLAYERS, 0.8f, 1.2f);
        VoidSoulHelper.spawnParticleEffect(player.level(), this.x, this.y, this.z, (ParticleOptions)ParticleTypes.SOUL, 10, 0.5, 0.0, 0.05, 0.0);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public boolean canBeBottled() {
        return this.canBeBottled;
    }

    public void setCanBeBottled(boolean canBeBottled) {
        this.canBeBottled = canBeBottled;
    }

    public static class VoidSoulHelper {
        public static void spawnVoidSoulParticles(Level level, double x, double y, double z, int count) {
            VoidSoulHelper.spawnParticleEffect(level, x, y, z, (ParticleOptions)DDParticleTypes.VOID_SOUL.get(), count, 2.0, 0.05, 0.05, 0.05);
        }

        public static void spawnParticleEffect(Level level, double x, double y, double z, ParticleOptions particleType, int count, double spread, double velX, double velY, double velZ) {
            if (level.isClientSide) {
                for (int i = 0; i < count; ++i) {
                    double finalVelX;
                    double offsetX = (level.random.nextDouble() - 0.5) * spread;
                    double offsetY = (level.random.nextDouble() - 0.5) * spread;
                    double offsetZ = (level.random.nextDouble() - 0.5) * spread;
                    double d = finalVelX = velX == 0.0 ? 0.0 : (level.random.nextDouble() - 0.5) * velX;
                    double finalVelY = velY == 0.0 ? 0.0 : (velY > 0.01 ? velY : level.random.nextDouble() * velY);
                    double finalVelZ = velZ == 0.0 ? 0.0 : (level.random.nextDouble() - 0.5) * velZ;
                    level.addParticle(particleType, x + offsetX, y + offsetY, z + offsetZ, finalVelX, finalVelY, finalVelZ);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class VoidSoulFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public VoidSoulFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            VoidSoulParticle particle = new VoidSoulParticle(level, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.pickSprite(this.spriteSet);
            return particle;
        }
    }
}

