/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.naterbobber.darkerdepths.blocks.TombBlock;
import com.naterbobber.darkerdepths.blocks.blockentities.TombBlockEntity;
import com.naterbobber.darkerdepths.client.models.TombModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

@OnlyIn(value=Dist.CLIENT)
public class TombBlockEntityRenderer
extends GeoBlockRenderer<TombBlockEntity> {
    public final EntityRenderDispatcher dispatcher;

    public TombBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new TombModel());
        this.dispatcher = context.getEntityRenderer();
    }

    public void actuallyRender(PoseStack poseStack, TombBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        if (animatable.isInhabited()) {
            this.renderSkeleton(animatable, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    private void renderSkeleton(TombBlockEntity blockEntity, float partialTick, PoseStack matrices, MultiBufferSource bufferSource, int packedLight) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return;
        }
        Skeleton skeleton = new Skeleton(EntityType.SKELETON, level);
        skeleton.yHeadRot = 0.0f;
        skeleton.yHeadRotO = 0.0f;
        ItemStack storedItem = blockEntity.getStoredItem();
        if (!storedItem.isEmpty()) {
            skeleton.setItemInHand(InteractionHand.MAIN_HAND, storedItem.copy());
        }
        matrices.pushPose();
        matrices.translate(1.0, 0.335, 0.5);
        matrices.mulPose(Axis.XP.rotationDegrees(-90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(90.0f));
        this.dispatcher.render((Entity)skeleton, 0.0, 0.0, 0.0, 0.0f, partialTick, matrices, bufferSource, packedLight);
        matrices.popPose();
    }

    public AABB getRenderBoundingBox(TombBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        BlockState state = blockEntity.getBlockState();
        if (state.getBlock() instanceof TombBlock) {
            Direction facing = (Direction)state.getValue((Property)TombBlock.FACING);
            return switch (facing) {
                case Direction.SOUTH -> AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-2, -8, -1), (BlockPos)pos.offset(3, 3, 8));
                case Direction.EAST -> AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, -8, -2), (BlockPos)pos.offset(8, 3, 3));
                case Direction.WEST -> AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-7, -8, -2), (BlockPos)pos.offset(2, 3, 3));
                default -> AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-2, -8, -7), (BlockPos)pos.offset(3, 3, 2));
            };
        }
        return super.getRenderBoundingBox((BlockEntity)blockEntity);
    }

    public boolean shouldRenderOffScreen(TombBlockEntity model) {
        return true;
    }
}

