/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.data.assets;

import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;

public class DDBlockStateProvider
extends BlockStateProvider {
    public DDBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "darkerdepths", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.AMBER);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.VOID_SOUL_REQUIEM);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.GLOW_GRIME);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.GLOWSHROOM_CAP);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.FORSAKEN_BRONZE_SCRAP);
        this.simpleItem((DeferredHolder<Item, ? extends Item>)DDItems.FORSAKEN_BRONZE_INGOT);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.AMBER_BLOCK);
        this.logBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.ARID_DEEPSLATE);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.GLOWSHROOM_BLOCK);
        this.logBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.GLOWSHROOM_STEM);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.LIVING_CRYSTAL);
        this.logBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.POROUS_PETRIFIED_LOG);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.ASH_BLOCK);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.FORSAKEN_BRONZE_BLOCK);
        this.simpleBlock((Block)DDBlocks.MOB_PLACER.get());
        this.crossBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.MOSSY_SPROUTS);
        this.crossBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.DRY_SPROUTS);
        this.logBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK, (DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_WALL);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_ARIDROCK, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_ARIDROCK_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_ARIDROCK_SLAB);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_BRICKS, (DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_BRICKS_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_BRICKS_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.ARIDROCK_BRICKS_WALL);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CHISELED_ARIDROCK_BRICKS);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CRACKED_ARIDROCK_BRICKS);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK, (DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_WALL);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_DUSKROCK, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_DUSKROCK_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_DUSKROCK_SLAB);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_BRICKS, (DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_BRICKS_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_BRICKS_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.DUSKROCK_BRICKS_WALL);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CHISELED_DUSKROCK_BRICKS);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CRACKED_DUSKROCK_BRICKS);
        this.logBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE, (DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_WALL);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_GRIMESTONE, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_GRIMESTONE_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_GRIMESTONE_SLAB);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_BRICKS, (DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_BRICKS_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_BRICKS_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.GRIMESTONE_BRICKS_WALL);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CHISELED_GRIMESTONE_BRICKS);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CRACKED_GRIMESTONE_BRICKS);
        this.logBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE, (DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_WALL);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_DARKSLATE, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_DARKSLATE_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.POLISHED_DARKSLATE_SLAB);
        this.simpleBlockSet((DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_BRICKS, (DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_BRICKS_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_BRICKS_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.DARKSLATE_BRICKS_WALL);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CHISELED_DARKSLATE_BRICKS);
        this.simpleBlockWithItem((DeferredHolder<Block, ? extends Block>)DDBlocks.CRACKED_DARKSLATE_BRICKS);
        this.simpleWoodTypeSet((DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_PLANKS, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_STAIRS, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_SLAB, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_FENCE, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_FENCE_GATE, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_DOOR, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_TRAPDOOR, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_PRESSURE_PLATE, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_BUTTON, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_LOG, (DeferredHolder<Block, ? extends Block>)DDBlocks.PETRIFIED_WOOD, (DeferredHolder<Block, ? extends Block>)DDBlocks.STRIPPED_PETRIFIED_LOG, (DeferredHolder<Block, ? extends Block>)DDBlocks.STRIPPED_PETRIFIED_WOOD);
    }

    private void simpleItem(DeferredHolder<Item, ? extends Item> item) {
        ((ItemModelBuilder)this.itemModels().withExistingParent(item.getId().getPath(), "item/generated")).texture("layer0", this.modLoc("item/" + item.getId().getPath()));
    }

    private void simpleBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.simpleBlock((Block)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void logBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.logBlock((RotatedPillarBlock)block.get());
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void stairsBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.stairsBlock((StairBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void slabBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.slabBlock((SlabBlock)block.get(), this.blockTexture((Block)parentTexture.get()), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void wallBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.wallBlock((WallBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.itemModels().wallInventory(block.getId().getPath(), this.blockTexture((Block)parentTexture.get()));
    }

    private void fenceBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.fenceBlock((FenceBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.itemModels().fenceInventory(block.getId().getPath(), this.blockTexture((Block)parentTexture.get()));
    }

    private void fenceGateBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.fenceGateBlock((FenceGateBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void doorBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation location = block.getId();
        ResourceLocation bottomTexture = location.withPath("block/" + location.getPath() + "_bottom");
        ResourceLocation topTexture = location.withPath("block/" + location.getPath() + "_top");
        this.doorBlock((DoorBlock)block.get(), bottomTexture, topTexture);
        ResourceLocation itemTexture = location.withPath("item/" + location.getPath());
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), "item/generated")).texture("layer0", itemTexture);
    }

    private void trapdoorBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        ResourceLocation location = block.getId();
        String path = "block/" + location.getPath();
        this.trapdoorBlock((TrapDoorBlock)block.get(), this.modLoc(path), true);
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.modLoc(path + "_bottom")));
    }

    private void pressurePlateBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.pressurePlateBlock((PressurePlateBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void buttonBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> parentTexture) {
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture((Block)parentTexture.get()));
        this.itemModels().buttonInventory(block.getId().getPath(), this.blockTexture((Block)parentTexture.get()));
    }

    private void woodBlockWithItem(DeferredHolder<Block, ? extends Block> block, DeferredHolder<Block, ? extends Block> logTextureSource) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)("block/" + logTextureSource.getId().getPath()));
        this.axisBlock((RotatedPillarBlock)block.get(), texture, texture);
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().getExistingFile(this.blockTexture((Block)block.get())));
    }

    private void crossBlockWithItem(DeferredHolder<Block, ? extends Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(block.getId().getPath(), this.blockTexture((Block)block.get()))).renderType("cutout"));
        ((ItemModelBuilder)this.itemModels().withExistingParent(block.getId().getPath(), "item/generated")).texture("layer0", this.blockTexture((Block)block.get()));
    }

    private void simpleBlockSet(DeferredHolder<Block, ? extends Block> baseBlock, DeferredHolder<Block, ? extends Block> stairsBlock, DeferredHolder<Block, ? extends Block> slabBlock, DeferredHolder<Block, ? extends Block> wallBlock) {
        this.simpleBlockWithItem(baseBlock);
        this.stairsBlockWithItem(stairsBlock, baseBlock);
        this.slabBlockWithItem(slabBlock, baseBlock);
        this.wallBlockWithItem(wallBlock, baseBlock);
    }

    private void simpleBlockSet(DeferredHolder<Block, ? extends Block> baseBlock, DeferredHolder<Block, ? extends Block> stairsBlock, DeferredHolder<Block, ? extends Block> slabBlock) {
        this.simpleBlockWithItem(baseBlock);
        this.stairsBlockWithItem(stairsBlock, baseBlock);
        this.slabBlockWithItem(slabBlock, baseBlock);
    }

    private void logBlockSet(DeferredHolder<Block, ? extends Block> baseBlock, DeferredHolder<Block, ? extends Block> stairsBlock, DeferredHolder<Block, ? extends Block> slabBlock, DeferredHolder<Block, ? extends Block> wallBlock) {
        this.logBlockWithItem(baseBlock);
        this.stairsBlockWithItem(stairsBlock, baseBlock);
        this.slabBlockWithItem(slabBlock, baseBlock);
        this.wallBlockWithItem(wallBlock, baseBlock);
    }

    private void simpleWoodTypeSet(DeferredHolder<Block, ? extends Block> plankBlock, DeferredHolder<Block, ? extends Block> stairsBlock, DeferredHolder<Block, ? extends Block> slabBlock, DeferredHolder<Block, ? extends Block> fenceBlock, DeferredHolder<Block, ? extends Block> fenceGateBlock, DeferredHolder<Block, ? extends Block> doorBlock, DeferredHolder<Block, ? extends Block> trapdoorBlock, DeferredHolder<Block, ? extends Block> pressurePlateBlock, DeferredHolder<Block, ? extends Block> buttonBlock, DeferredHolder<Block, ? extends Block> logBlock, DeferredHolder<Block, ? extends Block> woodBlock, DeferredHolder<Block, ? extends Block> strippedLogBlock, DeferredHolder<Block, ? extends Block> strippedWoodBlock) {
        this.simpleBlockWithItem(plankBlock);
        this.stairsBlockWithItem(stairsBlock, plankBlock);
        this.slabBlockWithItem(slabBlock, plankBlock);
        this.fenceBlockWithItem(fenceBlock, plankBlock);
        this.fenceGateBlockWithItem(fenceGateBlock, plankBlock);
        this.doorBlockWithItem(doorBlock);
        this.trapdoorBlockWithItem(trapdoorBlock);
        this.pressurePlateBlockWithItem(pressurePlateBlock, plankBlock);
        this.buttonBlockWithItem(buttonBlock, plankBlock);
        this.logBlockWithItem(logBlock);
        this.woodBlockWithItem(woodBlock, logBlock);
        this.logBlockWithItem(strippedLogBlock);
        this.woodBlockWithItem(strippedWoodBlock, strippedLogBlock);
    }
}

