/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.naterbobber.darkerdepths.init.DDItems;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

@EventBusSubscriber(modid="darkerdepths")
public class CommonEvents {
    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack leftStack = event.getLeft();
        ItemStack rightStack = event.getRight();
        if (leftStack.isEmpty() || !rightStack.is((Item)DDItems.VOID_SOUL_REQUIEM.get())) {
            return;
        }
        if (!CommonEvents.hasCurse(leftStack)) {
            return;
        }
        int cost = 25;
        ItemStack output = leftStack.copy();
        CommonEvents.removeCurses(output);
        event.setOutput(output);
        event.setCost(25L);
        event.setMaterialCost(1);
    }

    private static void removeCurses(ItemStack stack) {
        if (!CommonEvents.hasCurse(stack)) {
            return;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        enchantments.entrySet().forEach(entry -> {
            Holder enchantmentHolder = (Holder)entry.getKey();
            int level = entry.getIntValue();
            if (!enchantmentHolder.is(EnchantmentTags.CURSE)) {
                builder.set(enchantmentHolder, level);
            }
        });
        stack.set(DataComponents.ENCHANTMENTS, (Object)builder.toImmutable());
    }

    private static boolean hasCurse(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (enchantments.isEmpty()) {
            return false;
        }
        return enchantments.entrySet().stream().anyMatch(entry -> ((Holder)entry.getKey()).is(EnchantmentTags.CURSE));
    }
}

