/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events.client;

import com.naterbobber.darkerdepths.DarkerDepths;
import com.naterbobber.darkerdepths.client.ClientDeathAnchorAnimationOverlay;
import com.naterbobber.darkerdepths.events.client.ClientEvents;
import com.naterbobber.darkerdepths.init.DDDataComponents;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDWoodType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="darkerdepths", value={Dist.CLIENT})
public class ClientSetupEvents {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.register((Object)new ClientEvents());
        eventBus.register((Object)new ClientDeathAnchorAnimationOverlay());
        event.enqueueWork(() -> {
            DDWoodType.setupWoodTypes();
            ClientSetupEvents.registerStilettoProperties();
        });
    }

    private static void registerStilettoProperties() {
        ItemProperties.register((Item)((Item)DDItems.STILETTO.get()), (ResourceLocation)DarkerDepths.id("charge"), (itemStack, clientLevel, livingEntity, i) -> {
            int time = (Integer)itemStack.getOrDefault(DDDataComponents.STILETTO_TIME, (Object)0);
            int readyTime = (Integer)itemStack.getOrDefault(DDDataComponents.STILETTO_READY_TIME, (Object)0);
            if (time > 0) {
                return 1.0f;
            }
            if (readyTime > 0) {
                return 0.5f;
            }
            return 0.0f;
        });
    }
}

