/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.google.common.collect.Maps;
import com.naterbobber.darkerdepths.blocks.AshBlock;
import com.naterbobber.darkerdepths.blocks.AshFullBlock;
import com.naterbobber.darkerdepths.blocks.ConnectedPillarBlock;
import com.naterbobber.darkerdepths.blocks.CrystalMelonBlock;
import com.naterbobber.darkerdepths.blocks.DDCeilingHangingSignBlock;
import com.naterbobber.darkerdepths.blocks.DDLogBlock;
import com.naterbobber.darkerdepths.blocks.DDStandingSignBlock;
import com.naterbobber.darkerdepths.blocks.DDWallHangingSignBlock;
import com.naterbobber.darkerdepths.blocks.DDWallSignBlock;
import com.naterbobber.darkerdepths.blocks.DeadLivingCrystalBlock;
import com.naterbobber.darkerdepths.blocks.DeathAnchorBlock;
import com.naterbobber.darkerdepths.blocks.DrySproutsBlock;
import com.naterbobber.darkerdepths.blocks.DuskrockBlock;
import com.naterbobber.darkerdepths.blocks.GeyserBlock;
import com.naterbobber.darkerdepths.blocks.GlimmeringVinePlantBlock;
import com.naterbobber.darkerdepths.blocks.GlimmeringVinesBlock;
import com.naterbobber.darkerdepths.blocks.GlowshroomBlock;
import com.naterbobber.darkerdepths.blocks.GlowshroomLampBlock;
import com.naterbobber.darkerdepths.blocks.GlowshroomLanternBlock;
import com.naterbobber.darkerdepths.blocks.GlowspursBlock;
import com.naterbobber.darkerdepths.blocks.GrimestoneBlock;
import com.naterbobber.darkerdepths.blocks.LayeredDeepslateBlock;
import com.naterbobber.darkerdepths.blocks.LivingCrystalBlock;
import com.naterbobber.darkerdepths.blocks.MagmaPadBlock;
import com.naterbobber.darkerdepths.blocks.MobPlacerBlock;
import com.naterbobber.darkerdepths.blocks.MossyGrimestoneBlock;
import com.naterbobber.darkerdepths.blocks.ParanoiaAltarBlock;
import com.naterbobber.darkerdepths.blocks.PetrifiedRootBlock;
import com.naterbobber.darkerdepths.blocks.PetrifiedRootPlantBlock;
import com.naterbobber.darkerdepths.blocks.PorousBlock;
import com.naterbobber.darkerdepths.blocks.RopeBlock;
import com.naterbobber.darkerdepths.blocks.SproutsBlock;
import com.naterbobber.darkerdepths.blocks.StoneMelonBlock;
import com.naterbobber.darkerdepths.blocks.TombBlock;
import com.naterbobber.darkerdepths.blocks.VerticalSlabBlock;
import com.naterbobber.darkerdepths.blocks.VoidSoulJarBlock;
import com.naterbobber.darkerdepths.blocks.VoidSoulTorchBlock;
import com.naterbobber.darkerdepths.blocks.WallVoidSoulTorchBlock;
import com.naterbobber.darkerdepths.blocks.WoodPostBlock;
import com.naterbobber.darkerdepths.init.DDBlockSetTypes;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDParticleTypes;
import com.naterbobber.darkerdepths.init.DDSoundTypes;
import com.naterbobber.darkerdepths.init.DDWoodType;
import com.naterbobber.darkerdepths.item.BlockItemWithHoverText;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DDBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"darkerdepths");
    public static final Map<DeferredItem<? extends Item>, String> COMPAT = Maps.newLinkedHashMap();
    public static final BlockBehaviour.Properties PETRIFIED_LOG_PROPERTIES = DDBlocks.blockProperties(2.4f, 3.0f, SoundType.STEM, true);
    public static final BlockBehaviour.Properties PETRIFIED_PLANKS_PROPERTIES = DDBlocks.blockProperties(2.5f, 3.0f, SoundType.WOOD, true);
    public static final BlockBehaviour.Properties PETRIFIED_BUTTON_PROPERTIES = DDBlocks.blockProperties(0.5f, SoundType.WOOD, true);
    public static final BlockBehaviour.Properties PETRIFIED_SIGN_PROPERTIES = DDBlocks.blockProperties(1.0f, SoundType.WOOD, true).noCollission();
    public static final BlockBehaviour.Properties DARKSLATE_PROPERTIES = DDBlocks.blockProperties(3.5f, 6.5f, SoundType.DEEPSLATE, true);
    public static final BlockBehaviour.Properties DARKSLATE_BRICKS_PROPERTIES = DDBlocks.blockProperties(4.0f, 7.5f, SoundType.DEEPSLATE_BRICKS, true);
    public static final BlockBehaviour.Properties ARIDROCK_PROPERTIES = DDBlocks.blockProperties(1.5f, 6.0f, SoundType.STONE, true).mapColor(MapColor.SAND);
    public static final BlockBehaviour.Properties ARIDROCK_BRICKS_PROPERTIES = DDBlocks.blockProperties(2.0f, 6.0f, SoundType.STONE, true).mapColor(MapColor.SAND);
    public static final BlockBehaviour.Properties DUSKROCK_PROPERTIES = DDBlocks.blockProperties(1.25f, 4.0f, SoundType.TUFF, true);
    public static final BlockBehaviour.Properties DUSKROCK_BRICKS_PROPERTIES = DDBlocks.blockProperties(1.5f, 5.0f, SoundType.STONE, true);
    public static final BlockBehaviour.Properties LIVING_CRYSTAL_PROPERTIES = DDBlocks.blockProperties(4.0f, 7.5f, SoundType.DEEPSLATE, true).randomTicks();
    public static final BlockBehaviour.Properties FORSAKEN_BRONZE_PROPERTIES = DDBlocks.blockProperties(8.0f, 15.0f, SoundType.NETHERITE_BLOCK, true);
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_PETRIFIED_LOG = DDBlocks.registerBlock("stripped_petrified_log", () -> new RotatedPillarBlock(PETRIFIED_LOG_PROPERTIES));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_PETRIFIED_WOOD = DDBlocks.registerBlock("stripped_petrified_wood", () -> new RotatedPillarBlock(PETRIFIED_LOG_PROPERTIES));
    public static final DeferredBlock<RotatedPillarBlock> PETRIFIED_LOG = DDBlocks.registerBlock("petrified_log", () -> new DDLogBlock(PETRIFIED_LOG_PROPERTIES, (Block)STRIPPED_PETRIFIED_LOG.get()));
    public static final DeferredBlock<RotatedPillarBlock> PETRIFIED_WOOD = DDBlocks.registerBlock("petrified_wood", () -> new DDLogBlock(PETRIFIED_LOG_PROPERTIES, (Block)STRIPPED_PETRIFIED_WOOD.get()));
    public static final DeferredBlock<Block> PETRIFIED_PLANKS = DDBlocks.registerBlock("petrified_planks", () -> new Block(PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<Block> VERTICAL_PETRIFIED_PLANKS = DDBlocks.registerCompatBlock("quark", "vertical_petrified_planks", () -> new Block(PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<StairBlock> PETRIFIED_STAIRS = DDBlocks.registerBlock("petrified_stairs", () -> new StairBlock(((Block)PETRIFIED_PLANKS.get()).defaultBlockState(), PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<SlabBlock> PETRIFIED_SLAB = DDBlocks.registerBlock("petrified_slab", () -> new SlabBlock(PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> PETRIFIED_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "petrified_vertical_slab", () -> new VerticalSlabBlock(PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<FenceBlock> PETRIFIED_FENCE = DDBlocks.registerBlock("petrified_fence", () -> new FenceBlock(PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<FenceGateBlock> PETRIFIED_FENCE_GATE = DDBlocks.registerBlock("petrified_fence_gate", () -> new FenceGateBlock(DDWoodType.PETRIFIED, PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<DoorBlock> PETRIFIED_DOOR = DDBlocks.registerBlock("petrified_door", () -> new DoorBlock(DDBlockSetTypes.PETRIFIED, PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<TrapDoorBlock> PETRIFIED_TRAPDOOR = DDBlocks.registerBlock("petrified_trapdoor", () -> new TrapDoorBlock(DDBlockSetTypes.PETRIFIED, PETRIFIED_PLANKS_PROPERTIES));
    public static final DeferredBlock<PressurePlateBlock> PETRIFIED_PRESSURE_PLATE = DDBlocks.registerBlock("petrified_pressure_plate", () -> new PressurePlateBlock(DDBlockSetTypes.PETRIFIED, PETRIFIED_BUTTON_PROPERTIES));
    public static final DeferredBlock<ButtonBlock> PETRIFIED_BUTTON = DDBlocks.registerBlock("petrified_button", () -> new ButtonBlock(DDBlockSetTypes.PETRIFIED, 30, PETRIFIED_BUTTON_PROPERTIES));
    public static final DeferredBlock<DDStandingSignBlock> PETRIFIED_SIGN = DDBlocks.registerNoTabBlock("petrified_sign", () -> new DDStandingSignBlock(DDWoodType.PETRIFIED, PETRIFIED_SIGN_PROPERTIES));
    public static final DeferredBlock<DDWallSignBlock> PETRIFIED_WALL_SIGN = DDBlocks.registerNoTabBlock("petrified_wall_sign", () -> new DDWallSignBlock(PETRIFIED_SIGN_PROPERTIES, DDWoodType.PETRIFIED));
    public static final DeferredBlock<DDCeilingHangingSignBlock> PETRIFIED_HANGING_SIGN = DDBlocks.registerNoTabBlock("petrified_hanging_sign", () -> new DDCeilingHangingSignBlock(DDWoodType.PETRIFIED, PETRIFIED_SIGN_PROPERTIES));
    public static final DeferredBlock<DDWallHangingSignBlock> PETRIFIED_WALL_HANGING_SIGN = DDBlocks.registerNoTabBlock("petrified_wall_hanging_sign", () -> new DDWallHangingSignBlock(DDWoodType.PETRIFIED, PETRIFIED_SIGN_PROPERTIES));
    public static final DeferredBlock<WoodPostBlock> PETRIFIED_POST = DDBlocks.registerCompatBlock("quark", "petrified_post", () -> new WoodPostBlock(PETRIFIED_LOG_PROPERTIES.noOcclusion()));
    public static final DeferredBlock<WoodPostBlock> STRIPPED_PETRIFIED_POST = DDBlocks.registerCompatBlock("quark", "stripped_petrified_post", () -> new WoodPostBlock(PETRIFIED_LOG_PROPERTIES.noOcclusion()));
    public static final DeferredBlock<PorousBlock> POROUS_PETRIFIED_LOG = DDBlocks.registerBlock("porous_petrified_log", () -> new PorousBlock(PETRIFIED_LOG_PROPERTIES.randomTicks().lightLevel(value -> 6)));
    public static final DeferredBlock<RotatedPillarBlock> ARIDROCK = DDBlocks.registerBlock("aridrock", () -> new RotatedPillarBlock(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<StairBlock> ARIDROCK_STAIRS = DDBlocks.registerBlock("aridrock_stairs", () -> new StairBlock(((RotatedPillarBlock)ARIDROCK.get()).defaultBlockState(), ARIDROCK_PROPERTIES));
    public static final DeferredBlock<SlabBlock> ARIDROCK_SLAB = DDBlocks.registerBlock("aridrock_slab", () -> new SlabBlock(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> ARIDROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "aridrock_vertical_slab", () -> new VerticalSlabBlock(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<WallBlock> ARIDROCK_WALL = DDBlocks.registerBlock("aridrock_wall", () -> new WallBlock(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<Block> POLISHED_ARIDROCK = DDBlocks.registerBlock("polished_aridrock", () -> new Block(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<StairBlock> POLISHED_ARIDROCK_STAIRS = DDBlocks.registerBlock("polished_aridrock_stairs", () -> new StairBlock(((Block)POLISHED_ARIDROCK.get()).defaultBlockState(), ARIDROCK_PROPERTIES));
    public static final DeferredBlock<SlabBlock> POLISHED_ARIDROCK_SLAB = DDBlocks.registerBlock("polished_aridrock_slab", () -> new SlabBlock(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> POLISHED_ARIDROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_aridrock_vertical_slab", () -> new VerticalSlabBlock(ARIDROCK_PROPERTIES));
    public static final DeferredBlock<Block> ARIDROCK_BRICKS = DDBlocks.registerBlock("aridrock_bricks", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<StairBlock> ARIDROCK_BRICKS_STAIRS = DDBlocks.registerBlock("aridrock_bricks_stairs", () -> new StairBlock(((Block)ARIDROCK_BRICKS.get()).defaultBlockState(), ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<SlabBlock> ARIDROCK_BRICKS_SLAB = DDBlocks.registerBlock("aridrock_bricks_slab", () -> new SlabBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> ARIDROCK_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "aridrock_bricks_vertical_slab", () -> new VerticalSlabBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<WallBlock> ARIDROCK_BRICKS_WALL = DDBlocks.registerBlock("aridrock_bricks_wall", () -> new WallBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CHISELED_ARIDROCK_BRICKS = DDBlocks.registerBlock("chiseled_aridrock_bricks", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CRACKED_ARIDROCK_BRICKS = DDBlocks.registerBlock("cracked_aridrock_bricks", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<ConnectedPillarBlock> ARIDROCK_PILLAR = DDBlocks.registerBlock("aridrock_pillar", () -> new ConnectedPillarBlock(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> SKULL_WALL = DDBlocks.registerBlock("skull_wall", () -> new Block(ARIDROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<DuskrockBlock> DUSKROCK = DDBlocks.registerBlock("duskrock", () -> new DuskrockBlock(DUSKROCK_PROPERTIES));
    public static final DeferredBlock<StairBlock> DUSKROCK_STAIRS = DDBlocks.registerBlock("duskrock_stairs", () -> new StairBlock(((DuskrockBlock)((Object)((Object)DUSKROCK.get()))).defaultBlockState(), DUSKROCK_PROPERTIES));
    public static final DeferredBlock<SlabBlock> DUSKROCK_SLAB = DDBlocks.registerBlock("duskrock_slab", () -> new SlabBlock(DUSKROCK_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> DUSKROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "duskrock_vertical_slab", () -> new VerticalSlabBlock(DUSKROCK_PROPERTIES));
    public static final DeferredBlock<WallBlock> DUSKROCK_WALL = DDBlocks.registerBlock("duskrock_wall", () -> new WallBlock(DUSKROCK_PROPERTIES));
    public static final DeferredBlock<Block> POLISHED_DUSKROCK = DDBlocks.registerBlock("polished_duskrock", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<StairBlock> POLISHED_DUSKROCK_STAIRS = DDBlocks.registerBlock("polished_duskrock_stairs", () -> new StairBlock(((Block)POLISHED_DUSKROCK.get()).defaultBlockState(), DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<SlabBlock> POLISHED_DUSKROCK_SLAB = DDBlocks.registerBlock("polished_duskrock_slab", () -> new SlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> POLISHED_DUSKROCK_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_duskrock_vertical_slab", () -> new VerticalSlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> DUSKROCK_BRICKS = DDBlocks.registerBlock("duskrock_bricks", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<StairBlock> DUSKROCK_BRICKS_STAIRS = DDBlocks.registerBlock("duskrock_bricks_stairs", () -> new StairBlock(((Block)POLISHED_DUSKROCK.get()).defaultBlockState(), DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<SlabBlock> DUSKROCK_BRICKS_SLAB = DDBlocks.registerBlock("duskrock_bricks_slab", () -> new SlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> DUSKROCK_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "duskrock_bricks_vertical_slab", () -> new VerticalSlabBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<WallBlock> DUSKROCK_BRICKS_WALL = DDBlocks.registerBlock("duskrock_bricks_wall", () -> new WallBlock(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CHISELED_DUSKROCK_BRICKS = DDBlocks.registerBlock("chiseled_duskrock_bricks", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CRACKED_DUSKROCK_BRICKS = DDBlocks.registerBlock("cracked_duskrock_bricks", () -> new Block(DUSKROCK_BRICKS_PROPERTIES));
    public static final DeferredBlock<VoidSoulJarBlock> VOID_SOUL_JAR = DDBlocks.registerNoTabBlock("void_soul_jar", () -> new VoidSoulJarBlock(BlockBehaviour.Properties.of().strength(0.8f).sound(SoundType.GLASS).lightLevel(value -> 5)));
    public static final DeferredBlock<Block> FORSAKEN_BRONZE_BLOCK = DDBlocks.registerBlock("forsaken_bronze_block", () -> new Block(FORSAKEN_BRONZE_PROPERTIES));
    public static final DeferredBlock<DeathAnchorBlock> DEATH_ANCHOR = DDBlocks.registerTooltipBlock("death_anchor", () -> new DeathAnchorBlock(FORSAKEN_BRONZE_PROPERTIES), List.of(Component.translatable((String)"tooltip.darkerdepths.death_anchor.shift_desc_1").withStyle(ChatFormatting.GOLD), Component.translatable((String)"tooltip.darkerdepths.death_anchor.shift_desc_2").withStyle(ChatFormatting.GOLD)));
    public static final DeferredBlock<TombBlock> TOMB = DDBlocks.registerBlock("tomb", () -> new TombBlock(DDBlocks.blockProperties(4.0f, 10.0f, SoundType.DEEPSLATE, true).noOcclusion()));
    public static final DeferredBlock<ParanoiaAltarBlock> PARANOIA_ALTAR = DDBlocks.registerNoTabBlock("paranoia_altar", () -> new ParanoiaAltarBlock(DDBlocks.blockProperties(2.5f, 3.0f, SoundType.DEEPSLATE, true).lightLevel(level -> 9).noOcclusion()));
    public static final DeferredBlock<LayeredDeepslateBlock> ARID_DEEPSLATE = DDBlocks.registerBlock("arid_deepslate", () -> new LayeredDeepslateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).randomTicks()));
    public static final DeferredBlock<VoidSoulTorchBlock> VOID_SOUL_TORCH = DDBlocks.registerNoTabBlock("void_soul_torch", () -> new VoidSoulTorchBlock(() -> DDParticleTypes.VOID_SOUL_FLAME.get(), BlockBehaviour.Properties.of().strength(0.0f, 1.0f).noCollission().sound(SoundType.WOOD).lightLevel(state -> 10)));
    public static final DeferredBlock<WallVoidSoulTorchBlock> WALL_VOID_SOUL_TORCH = DDBlocks.registerNoTabBlock("wall_void_soul_torch", () -> new WallVoidSoulTorchBlock(() -> DDParticleTypes.VOID_SOUL_FLAME.get(), BlockBehaviour.Properties.of().strength(0.0f, 1.0f).noCollission().sound(SoundType.WOOD).lootFrom(VOID_SOUL_TORCH).lightLevel(state -> 12)));
    public static final DeferredBlock<PetrifiedRootBlock> PETRIFIED_ROOTS = DDBlocks.registerBlock("petrified_roots", () -> new PetrifiedRootBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).offsetType(BlockBehaviour.OffsetType.XZ).noCollission().instabreak().sound(SoundType.HANGING_ROOTS)));
    public static final DeferredBlock<PetrifiedRootPlantBlock> PETRIFIED_ROOTS_PLANT = DDBlocks.registerNoTabBlock("petrified_roots_plant", () -> new PetrifiedRootPlantBlock(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).offsetType(BlockBehaviour.OffsetType.XZ).noCollission().instabreak().sound(SoundType.HANGING_ROOTS)));
    public static final DeferredBlock<DrySproutsBlock> DRY_SPROUTS = DDBlocks.registerBlock("dry_sprouts", () -> new DrySproutsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEAD_BUSH).offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<Block> AMBER_BLOCK = DDBlocks.registerBlock("amber_block", () -> new Block(BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(1.0f).sound(SoundType.AMETHYST).lightLevel(value -> 7)));
    public static final DeferredBlock<AmethystClusterBlock> AMBER_CLUSTER = DDBlocks.registerBlock("amber_cluster", () -> new AmethystClusterBlock(6.0f, 3.0f, BlockBehaviour.Properties.of().requiresCorrectToolForDrops().strength(1.0f).sound(SoundType.SMALL_AMETHYST_BUD).lightLevel(value -> 7)));
    public static final DeferredBlock<RotatedPillarBlock> DARKSLATE = DDBlocks.registerBlock("darkslate", () -> new RotatedPillarBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<StairBlock> DARKSLATE_STAIRS = DDBlocks.registerBlock("darkslate_stairs", () -> new StairBlock(((RotatedPillarBlock)DARKSLATE.get()).defaultBlockState(), DARKSLATE_PROPERTIES));
    public static final DeferredBlock<SlabBlock> DARKSLATE_SLAB = DDBlocks.registerBlock("darkslate_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> DARKSLATE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "darkslate_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<WallBlock> DARKSLATE_WALL = DDBlocks.registerBlock("darkslate_wall", () -> new WallBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<Block> POLISHED_DARKSLATE = DDBlocks.registerBlock("polished_darkslate", () -> new Block(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<StairBlock> POLISHED_DARKSLATE_STAIRS = DDBlocks.registerBlock("polished_darkslate_stairs", () -> new StairBlock(((Block)POLISHED_DARKSLATE.get()).defaultBlockState(), DARKSLATE_PROPERTIES));
    public static final DeferredBlock<SlabBlock> POLISHED_DARKSLATE_SLAB = DDBlocks.registerBlock("polished_darkslate_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> POLISHED_DARKSLATE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_darkslate_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<Block> DARKSLATE_BRICKS = DDBlocks.registerBlock("darkslate_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<StairBlock> DARKSLATE_BRICKS_STAIRS = DDBlocks.registerBlock("darkslate_bricks_stairs", () -> new StairBlock(((Block)DARKSLATE_BRICKS.get()).defaultBlockState(), DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<SlabBlock> DARKSLATE_BRICKS_SLAB = DDBlocks.registerBlock("darkslate_bricks_slab", () -> new SlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> DARKSLATE_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "darkslate_bricks_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<WallBlock> DARKSLATE_BRICKS_WALL = DDBlocks.registerBlock("darkslate_bricks_wall", () -> new WallBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CHISELED_DARKSLATE_BRICKS = DDBlocks.registerBlock("chiseled_darkslate_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CRACKED_DARKSLATE_BRICKS = DDBlocks.registerBlock("cracked_darkslate_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<GeyserBlock> GEYSER = DDBlocks.registerBlock("geyser", () -> new GeyserBlock(DARKSLATE_PROPERTIES.randomTicks()));
    public static final DeferredBlock<StoneMelonBlock> STONE_MELON = DDBlocks.registerBlock("stone_melon", () -> new StoneMelonBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GRAY).requiresCorrectToolForDrops().strength(1.0f).sound(SoundType.DEEPSLATE)));
    public static final DeferredBlock<DeadLivingCrystalBlock> DEAD_LIVING_CRYSTAL = DDBlocks.registerBlock("dead_living_crystal", () -> new DeadLivingCrystalBlock(LIVING_CRYSTAL_PROPERTIES));
    public static final DeferredBlock<LivingCrystalBlock> LIVING_CRYSTAL = DDBlocks.registerBlock("living_crystal", () -> new LivingCrystalBlock(LIVING_CRYSTAL_PROPERTIES));
    public static final DeferredBlock<CrystalMelonBlock> CRYSTAL_MELON = DDBlocks.registerTooltipBlock("crystal_melon", () -> new CrystalMelonBlock(DDBlocks.blockProperties(1.5f, 1.0f, SoundType.AMETHYST, true).lightLevel(value -> 10)), List.of(Component.translatable((String)"tooltip.darkerdepths.crystal_melon.shift_desc_1").withStyle(ChatFormatting.AQUA), Component.translatable((String)"tooltip.darkerdepths.crystal_melon.shift_desc_2").withStyle(ChatFormatting.AQUA)));
    public static final DeferredBlock<MagmaPadBlock> MAGMA_PAD = DDBlocks.registerNoTabBlock("magma_pad", () -> new MagmaPadBlock(BlockBehaviour.Properties.of().strength(0.1f).lightLevel(state -> 3).sound(DDSoundTypes.GRIMESTONE.get()).noOcclusion().pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<AshFullBlock> ASH_BLOCK = DDBlocks.registerBlock("ash_block", () -> new AshFullBlock(DDBlocks.blockProperties(0.2f, SoundType.SNOW, false).mapColor(MapColor.COLOR_BLACK).randomTicks()));
    public static final DeferredBlock<AshBlock> ASH = DDBlocks.registerBlock("ash", () -> new AshBlock(DDBlocks.blockProperties(0.1f, SoundType.SNOW, true).mapColor(MapColor.COLOR_BLACK).randomTicks()));
    public static final DeferredBlock<GrimestoneBlock> GRIMESTONE = DDBlocks.registerBlock("grimestone", () -> new GrimestoneBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<StairBlock> GRIMESTONE_STAIRS = DDBlocks.registerBlock("grimestone_stairs", () -> new StairBlock(((GrimestoneBlock)((Object)((Object)GRIMESTONE.get()))).defaultBlockState(), DARKSLATE_PROPERTIES));
    public static final DeferredBlock<SlabBlock> GRIMESTONE_SLAB = DDBlocks.registerBlock("grimestone_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> GRIMESTONE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "grimestone_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<WallBlock> GRIMESTONE_WALL = DDBlocks.registerBlock("grimestone_wall", () -> new WallBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<MossyGrimestoneBlock> MOSSY_GRIMESTONE = DDBlocks.registerBlock("mossy_grimestone", () -> new MossyGrimestoneBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<Block> POLISHED_GRIMESTONE = DDBlocks.registerBlock("polished_grimestone", () -> new Block(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<StairBlock> POLISHED_GRIMESTONE_STAIRS = DDBlocks.registerBlock("polished_grimestone_stairs", () -> new StairBlock(((Block)POLISHED_GRIMESTONE.get()).defaultBlockState(), DARKSLATE_PROPERTIES));
    public static final DeferredBlock<SlabBlock> POLISHED_GRIMESTONE_SLAB = DDBlocks.registerBlock("polished_grimestone_slab", () -> new SlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> POLISHED_GRIMESTONE_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "polished_grimestone_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_PROPERTIES));
    public static final DeferredBlock<Block> GRIMESTONE_BRICKS = DDBlocks.registerBlock("grimestone_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<StairBlock> GRIMESTONE_BRICKS_STAIRS = DDBlocks.registerBlock("grimestone_bricks_stairs", () -> new StairBlock(((Block)GRIMESTONE_BRICKS.get()).defaultBlockState(), DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<SlabBlock> GRIMESTONE_BRICKS_SLAB = DDBlocks.registerBlock("grimestone_bricks_slab", () -> new SlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<VerticalSlabBlock> GRIMESTONE_BRICKS_VERTICAL_SLAB = DDBlocks.registerCompatBlock("quark", "grimestone_bricks_vertical_slab", () -> new VerticalSlabBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<WallBlock> GRIMESTONE_BRICKS_WALL = DDBlocks.registerBlock("grimestone_bricks_wall", () -> new WallBlock(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CHISELED_GRIMESTONE_BRICKS = DDBlocks.registerBlock("chiseled_grimestone_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> CRACKED_GRIMESTONE_BRICKS = DDBlocks.registerBlock("cracked_grimestone_bricks", () -> new Block(DARKSLATE_BRICKS_PROPERTIES));
    public static final DeferredBlock<Block> GLOWSHROOM_BLOCK = DDBlocks.registerBlock("glowshroom_block", () -> new Block(BlockBehaviour.Properties.of().strength(0.5f).sound(SoundType.SLIME_BLOCK)));
    public static final DeferredBlock<RotatedPillarBlock> GLOWSHROOM_STEM = DDBlocks.registerBlock("glowshroom_stem", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().strength(1.2f, 2.0f).sound(SoundType.STEM)));
    public static final DeferredBlock<Block> GLOWSHROOM_HEART = DDBlocks.registerBlock("glowshroom_heart", () -> new Block(BlockBehaviour.Properties.of().strength(2.0f, 3.0f).sound(SoundType.SHROOMLIGHT).lightLevel(value -> 15)));
    public static final DeferredBlock<GlowshroomBlock> GLOWSHROOM = DDBlocks.registerBlock("glowshroom", () -> new GlowshroomBlock(BlockBehaviour.Properties.of().strength(0.0f, 1.0f).sound(SoundType.SLIME_BLOCK).lightLevel(state -> 3 + 2 * (Integer)state.getValue((Property)GlowshroomBlock.CLUSTERS_1_3)).noCollission()));
    public static final DeferredBlock<FlowerPotBlock> POTTED_GLOWSHROOM = DDBlocks.registerNoTabBlock("potted_glowshroom", () -> new FlowerPotBlock((Block)GLOWSHROOM.get(), BlockBehaviour.Properties.of().instabreak().noOcclusion()));
    public static final DeferredBlock<GlowspursBlock> GLOWSPURS = DDBlocks.registerBlock("glowspurs", () -> new GlowspursBlock(BlockBehaviour.Properties.of().instabreak().lightLevel(value -> 5).sound(SoundType.SLIME_BLOCK).noCollission()));
    public static final DeferredBlock<SproutsBlock> MOSSY_SPROUTS = DDBlocks.registerBlock("mossy_sprouts", () -> new SproutsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).sound(SoundType.WET_GRASS).offsetType(BlockBehaviour.OffsetType.XZ)));
    public static final DeferredBlock<GlimmeringVinesBlock> GLIMMERING_VINES = DDBlocks.registerBlock("glimmering_vines", () -> new GlimmeringVinesBlock(BlockBehaviour.Properties.of().noCollission().lightLevel(value -> 8).sound(SoundType.SPORE_BLOSSOM)));
    public static final DeferredBlock<GlimmeringVinePlantBlock> GLIMMERING_VINE_PLANT = DDBlocks.registerNoTabBlock("glimmering_vine_plant", () -> new GlimmeringVinePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLIMMERING_VINES.get())).sound(SoundType.SPORE_BLOSSOM)));
    public static final DeferredBlock<GlowshroomLampBlock> GLOWSHROOM_LAMP = DDBlocks.registerBlock("glowshroom_lamp", () -> new GlowshroomLampBlock(BlockBehaviour.Properties.of().strength(0.3f, 0.3f).lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0).sound(SoundType.GLASS)));
    public static final DeferredBlock<GlowshroomLanternBlock> GLOWSHROOM_LANTERN = DDBlocks.registerBlock("glowshroom_lantern", () -> new GlowshroomLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN)));
    public static final DeferredBlock<RopeBlock> ROPE = DDBlocks.registerNoTabBlock("rope", () -> new RopeBlock(DDBlocks.blockProperties(0.1f, SoundType.WOOL, false)));
    public static final DeferredBlock<MobPlacerBlock> MOB_PLACER = DDBlocks.registerNoTabBlock("mob_placer", () -> new MobPlacerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK)));

    public static <B extends Block> DeferredBlock<B> registerBlock(String name, Supplier<? extends B> blocks) {
        DeferredBlock block = BLOCKS.register(name, blocks);
        DDItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public static <B extends Block> DeferredBlock<B> registerNoTabBlock(String name, Supplier<? extends B> blocks) {
        return BLOCKS.register(name, blocks);
    }

    public static <B extends Block> DeferredBlock<B> registerTooltipBlock(String name, Supplier<? extends B> blocks, List<Component> tooltips) {
        DeferredBlock block = BLOCKS.register(name, blocks);
        DDItems.ITEMS.register(name, () -> new BlockItemWithHoverText((Block)block.get(), new Item.Properties(), tooltips));
        return block;
    }

    public static <B extends Block> DeferredBlock<B> registerCompatBlock(String modId, String key, Supplier<B> blockSupplier) {
        DeferredBlock block = BLOCKS.register(key, blockSupplier);
        DeferredItem item = DDItems.ITEMS.register(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        COMPAT.put((DeferredItem<? extends Item>)item, modId);
        return block;
    }

    public static BlockBehaviour.Properties blockProperties(float destroyTime, float explosionResistance, SoundType sound, boolean requiresTool) {
        if (requiresTool) {
            return BlockBehaviour.Properties.of().strength(destroyTime, explosionResistance).sound(sound).requiresCorrectToolForDrops();
        }
        return BlockBehaviour.Properties.of().strength(destroyTime, explosionResistance).sound(sound);
    }

    public static BlockBehaviour.Properties blockProperties(float destroyTime, SoundType sound, boolean requiresTool) {
        if (requiresTool) {
            return BlockBehaviour.Properties.of().strength(destroyTime).sound(sound).requiresCorrectToolForDrops();
        }
        return BlockBehaviour.Properties.of().strength(destroyTime).sound(sound);
    }
}

