/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.google.common.collect.Lists;
import com.naterbobber.darkerdepths.DarkerDepths;
import com.naterbobber.darkerdepths.component.DDEnchantmentEffects;
import com.naterbobber.darkerdepths.init.DDItemTags;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;

public class DDEnchantments {
    public static final List<ResourceKey<Enchantment>> ENCHANTMENTS = Lists.newArrayList();
    public static final ResourceKey<Enchantment> SWIFT_STRIKE = DDEnchantments.key("swift_strike");
    public static final ResourceKey<Enchantment> QUICK_DASH = DDEnchantments.key("quick_dash");

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter itemLookup = context.lookup(Registries.ITEM);
        HolderGetter enchantmentLookup = context.lookup(Registries.ENCHANTMENT);
        DDEnchantments.register(context, SWIFT_STRIKE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(DDItemTags.STILETTO_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)9), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(DDEnchantmentEffects.SWIFT_STRIKE_HIT.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
        DDEnchantments.register(context, QUICK_DASH, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemLookup.getOrThrow(DDItemTags.STILETTO_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)9), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(DDEnchantmentEffects.QUICK_DASH_DURATION.get(), (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        context.register(key, (Object)builder.build(key.location()));
    }

    private static ResourceKey<Enchantment> key(String name) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)DarkerDepths.id(name));
        ENCHANTMENTS.add((ResourceKey<Enchantment>)key);
        return key;
    }
}

