/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.naterbobber.darkerdepths.DarkerDepths;
import com.naterbobber.darkerdepths.init.DDConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;

public class DDPlacedFeatures {
    public static final ResourceKey<PlacedFeature> HUGE_GLOWSHROOM = DDPlacedFeatures.createKey("huge_glowshroom");
    public static final ResourceKey<PlacedFeature> GLOWSHROOM_PATCH = DDPlacedFeatures.createKey("glowshroom_patch");
    public static final ResourceKey<PlacedFeature> AMBER = DDPlacedFeatures.createKey("amber");
    public static final ResourceKey<PlacedFeature> MOLTEN_SPRING = DDPlacedFeatures.createKey("molten_spring");
    public static final ResourceKey<PlacedFeature> MOLTEN_POOL = DDPlacedFeatures.createKey("molten_pool");
    public static final ResourceKey<PlacedFeature> DARKSLATE_PLACEMENT = DDPlacedFeatures.createKey("darkslate_placement");
    public static final ResourceKey<PlacedFeature> CATACOMBS_SAND_PLACEMENT = DDPlacedFeatures.createKey("catacombs_sand_placement");
    public static final ResourceKey<PlacedFeature> CATACOMBS_LAYERED_PLACEMENT = DDPlacedFeatures.createKey("catacombs_layered_placement");
    public static final ResourceKey<PlacedFeature> PETRIFIED_BRANCH = DDPlacedFeatures.createKey("petrified_branch");
    public static final ResourceKey<PlacedFeature> MAGMA_ORE = DDPlacedFeatures.createKey("magma_ore");
    public static final ResourceKey<PlacedFeature> GRIME_SURFACE = DDPlacedFeatures.createKey("grime_surface");
    public static final ResourceKey<PlacedFeature> ARID_SURFACE = DDPlacedFeatures.createKey("arid_surface");
    public static final ResourceKey<PlacedFeature> DARKSLATE_SURFACE = DDPlacedFeatures.createKey("darkslate_surface");
    public static final ResourceKey<PlacedFeature> ARID_BOULDER = DDPlacedFeatures.createKey("arid_boulder");
    public static final ResourceKey<PlacedFeature> CATACOMBS_LAVA_LINING = DDPlacedFeatures.createKey("catacombs_lava_lining");
    public static final ResourceKey<PlacedFeature> DUSKROCK_STRIPE = DDPlacedFeatures.createKey("duskrock_stripe");
    public static final ResourceKey<PlacedFeature> GLIMMERING_VINES = DDPlacedFeatures.createKey("glimmering_vines");
    public static final ResourceKey<PlacedFeature> DEAD_LIVING_CRYSTAL_ORE = DDPlacedFeatures.createKey("dead_living_crystal_ore");
    public static final ResourceKey<PlacedFeature> DUSKROCK_ORE = DDPlacedFeatures.createKey("duskrock_ore");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter lookup = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, HUGE_GLOWSHROOM, (Holder)lookup.getOrThrow(DDConfiguredFeatures.HUGE_GLOWSHROOM), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)140, (int)180)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, GLOWSHROOM_PATCH, (Holder)lookup.getOrThrow(DDConfiguredFeatures.GLOWSHROOM_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)3, (int)8)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12)});
        PlacementUtils.register(context, AMBER, (Holder)lookup.getOrThrow(DDConfiguredFeatures.AMBERS_PLACEMENT), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)120, (int)180)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, MOLTEN_SPRING, (Holder)lookup.getOrThrow(DDConfiguredFeatures.MOLTEN_SPRING), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)20), InSquarePlacement.spread(), HeightRangePlacement.of((HeightProvider)VeryBiasedToBottomHeight.of((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.belowTop((int)32), (int)32)), BiomeFilter.biome()});
        PlacementUtils.register(context, MOLTEN_POOL, (Holder)lookup.getOrThrow(DDConfiguredFeatures.MOLTEN_POOL), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)60), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(context, DARKSLATE_PLACEMENT, (Holder)lookup.getOrThrow(DDConfiguredFeatures.DARKSLATE_PLACEMENT), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)175), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, CATACOMBS_SAND_PLACEMENT, (Holder)lookup.getOrThrow(DDConfiguredFeatures.CATACOMBS_SAND_PLACEMENT), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)48), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, CATACOMBS_LAYERED_PLACEMENT, (Holder)lookup.getOrThrow(DDConfiguredFeatures.CATACOMBS_LAYERED_PLACEMENT), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)150), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, PETRIFIED_BRANCH, (Holder)lookup.getOrThrow(DDConfiguredFeatures.PETRIFIED_BRANCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)150), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, DEAD_LIVING_CRYSTAL_ORE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.DEAD_LIVING_CRYSTAL_ORE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)256), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, MAGMA_ORE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.MAGMA_ORE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)30), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, GRIME_SURFACE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.GRIME_SURFACE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, ARID_SURFACE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.ARID_SURFACE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, DARKSLATE_SURFACE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.DARKSLATE_SURFACE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, ARID_BOULDER, (Holder)lookup.getOrThrow(DDConfiguredFeatures.ARID_BOULDER), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, DUSKROCK_ORE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.DUSKROCK_ORE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)32), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(context, CATACOMBS_LAVA_LINING, (Holder)lookup.getOrThrow(DDConfiguredFeatures.CATACOMBS_LAVA_LINING), List.of(CountPlacement.of((int)96), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-63), (VerticalAnchor)VerticalAnchor.absolute((int)-1)), BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.not((BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.AIR}))), BiomeFilter.biome()));
        PlacementUtils.register(context, DUSKROCK_STRIPE, (Holder)lookup.getOrThrow(DDConfiguredFeatures.DUSKROCK_STRIPE), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)96, (int)128)), InSquarePlacement.spread(), HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.BOTTOM, (VerticalAnchor)VerticalAnchor.belowTop((int)16)), BiomeFilter.biome()});
        PlacementUtils.register(context, GLIMMERING_VINES, (Holder)lookup.getOrThrow(DDConfiguredFeatures.GLIMMERING_VINES), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1)), BiomeFilter.biome()});
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)DarkerDepths.id(name));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier2) {
        return List.of(modifier, InSquarePlacement.spread(), modifier2, BiomeFilter.biome());
    }
}

