/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.mojang.datafixers.util.Pair;
import com.naterbobber.darkerdepths.data.tags.DDBiomeTagsProvider;
import com.naterbobber.darkerdepths.init.DDProcessorLists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class DDStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"darkerdepths");
    public static final DeferredHolder<StructureType<?>, StructureType<JigsawStructure>> DD_JIGSAW_TYPE = STRUCTURE_TYPES.register("dd_jigsaw", () -> () -> JigsawStructure.CODEC);
    public static final ResourceKey<Structure> ROPE_MINE_FOREST = DDStructures.createStructureKey("rope_mine_forest");
    public static final ResourceKey<StructureSet> ROPE_MINE_FOREST_SET = DDStructures.createStructureSetKey("rope_mine_forest");
    public static final ResourceKey<StructureTemplatePool> ROPE_MINE_FOREST_POOL = DDStructures.createPoolKey("rope_mine_forest");
    public static final ResourceKey<Structure> ROPE_MINE_DESERT = DDStructures.createStructureKey("rope_mine_desert");
    public static final ResourceKey<StructureSet> ROPE_MINE_DESERT_SET = DDStructures.createStructureSetKey("rope_mine_desert");
    public static final ResourceKey<StructureTemplatePool> ROPE_MINE_DESERT_POOL = DDStructures.createPoolKey("rope_mine_desert");
    public static final ResourceKey<Structure> CATACOMBS = DDStructures.createStructureKey("catacombs");
    public static final ResourceKey<StructureSet> CATACOMBS_SET = DDStructures.createStructureSetKey("catacombs_set");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_STARTS_POOL = DDStructures.createPoolKey("catacombs/starts");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_HALLS_POOL = DDStructures.createPoolKey("catacombs/halls");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_CENTER_EXTENSIONS_POOL = DDStructures.createPoolKey("catacombs/center_extensions");
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_HALLS_EXTENSIONS = DDStructures.createPoolKey("catacombs/extensions");

    public static void bootstrap(BootstrapContext<Structure> context) {
        HolderGetter biomeGetter = context.lookup(Registries.BIOME);
        HolderGetter poolGetter = context.lookup(Registries.TEMPLATE_POOL);
        Structure.StructureSettings forestSettings = new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(DDBiomeTagsProvider.HAS_ROPE_MINE_FOREST), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        context.register(ROPE_MINE_FOREST, (Object)new JigsawStructure(forestSettings, (Holder)poolGetter.getOrThrow(ROPE_MINE_FOREST_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-10)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        Structure.StructureSettings desertSettings = new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(DDBiomeTagsProvider.HAS_ROPE_MINE_DESERT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE);
        context.register(ROPE_MINE_DESERT, (Object)new JigsawStructure(desertSettings, (Holder)poolGetter.getOrThrow(ROPE_MINE_DESERT_POOL), Optional.empty(), 1, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-18)), true, Optional.of(Heightmap.Types.WORLD_SURFACE_WG), 80, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
        Structure.StructureSettings catacombs = new Structure.StructureSettings((HolderSet)biomeGetter.getOrThrow(DDBiomeTagsProvider.CATACOMBS), Arrays.stream(MobCategory.values()).collect(Collectors.toMap(v -> v, v1 -> new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.create()))), GenerationStep.Decoration.VEGETAL_DECORATION, TerrainAdjustment.BURY);
        context.register(CATACOMBS, (Object)new JigsawStructure(catacombs, (Holder)poolGetter.getOrThrow(CATACOMBS_STARTS_POOL), Optional.empty(), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-10)), false, Optional.empty(), 116, List.of(), JigsawStructure.DEFAULT_DIMENSION_PADDING, JigsawStructure.DEFAULT_LIQUID_SETTINGS));
    }

    public static void bootstrapStructureSet(BootstrapContext<StructureSet> context) {
        HolderGetter structureGetter = context.lookup(Registries.STRUCTURE);
        context.register(ROPE_MINE_FOREST_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(ROPE_MINE_FOREST), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 1234567890)));
        context.register(ROPE_MINE_DESERT_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(ROPE_MINE_DESERT), (StructurePlacement)new RandomSpreadStructurePlacement(28, 10, RandomSpreadType.LINEAR, 1234567891)));
        context.register(CATACOMBS_SET, (Object)new StructureSet((Holder)structureGetter.getOrThrow(CATACOMBS), (StructurePlacement)new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.LINEAR, 20083232)));
    }

    public static void bootstrapTemplatePool(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPoolHolder = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter processorList = context.lookup(Registries.PROCESSOR_LIST);
        Holder.Reference catacombsProcessor = processorList.getOrThrow(DDProcessorLists.CATACOMBS_PROCESSOR);
        Holder.Reference ropeMineProcessor = processorList.getOrThrow(DDProcessorLists.ROPE_MINES_PROCESSOR);
        context.register(ROPE_MINE_FOREST_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:rope_mine_forest", (Holder)ropeMineProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.register(ROPE_MINE_DESERT_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:rope_mine_desert", (Holder)ropeMineProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.register(CATACOMBS_STARTS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/center_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/center_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        context.register(CATACOMBS_CENTER_EXTENSIONS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20))));
        context.register(CATACOMBS_HALLS_POOL, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/cross_section_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10))));
        context.register(CATACOMBS_HALLS_EXTENSIONS, (Object)new StructureTemplatePool((Holder)emptyPoolHolder, List.of(Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/hallway_large_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)50), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)5), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_4", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_5", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_6", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_7", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/room_8", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)10), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/treasure_room_1", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/treasure_room_2", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)30), Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"darkerdepths:catacombs/treasure_room_3", (Holder)catacombsProcessor).apply(StructureTemplatePool.Projection.RIGID)), (Object)20))));
    }

    private static ResourceKey<Structure> createStructureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)name));
    }

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)name));
    }

    private static ResourceKey<StructureTemplatePool> createPoolKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)name));
    }

    public static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"darkerdepths", (String)name));
    }
}

