/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.item;

import com.naterbobber.darkerdepths.component.DDEnchantmentEffects;
import com.naterbobber.darkerdepths.init.DDDataComponents;
import com.naterbobber.darkerdepths.init.DDItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.apache.commons.lang3.mutable.MutableFloat;

public class StilettoItem
extends SwordItem {
    public static final StilettoTier STILETTO = new StilettoTier();
    public static final String TIME_FRAME = "TimeFrame";
    public static final String READY_TICKS = "ReadyTicks";

    public StilettoItem(Item.Properties properties) {
        super((Tier)STILETTO, properties.component(DataComponents.TOOL, (Object)StilettoItem.createToolProperties()));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isFallFlying() || player.isCrouching()) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        itemStack.hurtAndBreak(2, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        double dash = 1.85;
        player.addDeltaMovement(player.getLookAngle().multiply(1.0, 1.5, 1.0).normalize().multiply(dash, dash / 2.0, dash));
        player.playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MutableFloat mutableFloat = new MutableFloat(0.0f);
            EnchantmentHelper.runIterationOnItem((ItemStack)itemStack, (holder, i) -> ((Enchantment)holder.value()).modifyItemFilteredCount(DDEnchantmentEffects.QUICK_DASH_DURATION.get(), serverLevel, i, itemStack, mutableFloat));
            int quickDash = Math.max(0, mutableFloat.intValue());
            int cooldown = 200;
            int reducedCooldown = (int)((float)cooldown * (1.0f - 0.25f * (float)quickDash));
            if (!player.getCooldowns().isOnCooldown(itemStack.getItem())) {
                player.getCooldowns().addCooldown(itemStack.getItem(), reducedCooldown);
            }
            itemStack.set(DDDataComponents.STILETTO_TIME, (Object)20);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int index, boolean selected) {
        Player player;
        int readyTicks;
        int timeframe = (Integer)itemStack.getOrDefault(DDDataComponents.STILETTO_TIME, (Object)0);
        if (timeframe > 0) {
            itemStack.set(DDDataComponents.STILETTO_TIME, (Object)(timeframe - 1));
        }
        if ((readyTicks = ((Integer)itemStack.getOrDefault(DDDataComponents.STILETTO_READY_TIME, (Object)0)).intValue()) > 0) {
            itemStack.set(DDDataComponents.STILETTO_READY_TIME, (Object)(readyTicks - 1));
        }
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().getCooldownPercent((Item)this, 0.0f) == 0.1f) {
            itemStack.set(DDDataComponents.STILETTO_READY_TIME, (Object)10);
        }
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.darkerdepths.press_shift").withStyle(ChatFormatting.GRAY));
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"tooltip.darkerdepths.stiletto.shift_desc").withStyle(ChatFormatting.YELLOW));
        }
        super.appendHoverText(pStack, context, pTooltipComponents, pIsAdvanced);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        if (itemAbility == ItemAbilities.SWORD_SWEEP) {
            return false;
        }
        return super.canPerformAction(stack, itemAbility);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (stack.is(DDItems.STILETTO.asItem())) {
            return !enchantment.is(Enchantments.SWEEPING_EDGE);
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public static class StilettoTier
    implements Tier {
        public int getUses() {
            return 400;
        }

        public float getSpeed() {
            return 0.0f;
        }

        public float getAttackDamageBonus() {
            return 2.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return null;
        }

        public int getEnchantmentValue() {
            return 10;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DDItems.FORSAKEN_BRONZE_SCRAP.get()});
        }
    }
}

