/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.item;

import com.naterbobber.darkerdepths.client.render.renderers.VoidSoulJarItemRenderer;
import com.naterbobber.darkerdepths.entities.VoidSoulEntity;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoidSoulJarItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public VoidSoulJarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.getItemInHand(pUsedHand);
        pLevel.playSound(pPlayer, pPlayer.blockPosition(), SoundEvents.WITCH_DRINK, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!pLevel.isClientSide()) {
            VoidSoulEntity voidSoul = new VoidSoulEntity((EntityType<? extends PathfinderMob>)((EntityType)DDEntityTypes.VOID_SOUL.get()), pLevel);
            Vec3 spawnPos = pPlayer.getEyePosition().add(pPlayer.getLookAngle().scale(1.5));
            voidSoul.setPos(spawnPos);
            pLevel.addFreshEntity((Entity)voidSoul);
            if (!pPlayer.getAbilities().instabuild) {
                heldStack.shrink(1);
                ItemStack bottleStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (heldStack.isEmpty()) {
                    return InteractionResultHolder.success((Object)bottleStack);
                }
                if (!pPlayer.getInventory().add(bottleStack)) {
                    pPlayer.drop(bottleStack, false);
                }
            }
        }
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        pPlayer.getCooldowns().addCooldown((Item)this, 10);
        return InteractionResultHolder.success((Object)heldStack);
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(this){
            private VoidSoulJarItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new VoidSoulJarItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private PlayState animationPredicate(AnimationState<VoidSoulJarItem> state) {
        state.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }
}

