/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.blocks.DuskrockBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CatacombsLavaLiningFeature
extends Feature<NoneFeatureConfiguration> {
    public CatacombsLavaLiningFeature(Codec<NoneFeatureConfiguration> p_65792_) {
        super(p_65792_);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        int blocksPlaced = 0;
        int searchRadius = 8;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos currentPos = origin.offset(x, y, z);
                    BlockState blockState = world.getBlockState(currentPos);
                    if (!blockState.is(Blocks.LAVA)) continue;
                    for (Direction direction : Direction.values()) {
                        BlockPos adjacentPos = currentPos.relative(direction);
                        BlockState adjacentBlockState = world.getBlockState(adjacentPos);
                        if (adjacentBlockState.is(Blocks.LAVA) || !adjacentBlockState.is(BlockTags.BASE_STONE_OVERWORLD) && !adjacentBlockState.is((Block)DDBlocks.ARID_DEEPSLATE.get()) && !adjacentBlockState.is((Block)DDBlocks.ARIDROCK.get()) && !adjacentBlockState.is((Block)DDBlocks.DUSKROCK.get()) && !adjacentBlockState.is(Blocks.PACKED_MUD)) continue;
                        world.setBlock(adjacentPos, ((RotatedPillarBlock)DDBlocks.DARKSLATE.get()).defaultBlockState(), 2);
                        ++blocksPlaced;
                        if (world.getBlockState(adjacentPos.above()).is((Block)DDBlocks.DRY_SPROUTS.get())) {
                            world.setBlock(adjacentPos.above(), Blocks.AIR.defaultBlockState(), 2);
                        }
                        this.placeCluster(world, adjacentPos, random);
                    }
                }
            }
        }
        return blocksPlaced > 0;
    }

    public void placeCluster(WorldGenLevel world, BlockPos centerPos, RandomSource random) {
        int clusterRadius = 1 + random.nextInt(2);
        int replacedCount = 0;
        for (int x = -clusterRadius; x <= clusterRadius; ++x) {
            for (int y = -clusterRadius; y <= clusterRadius; ++y) {
                for (int z = -clusterRadius; z <= clusterRadius; ++z) {
                    BlockPos currentClusterPos;
                    BlockState currentClusterBlockState;
                    if (x * x + y * y + z * z > clusterRadius * clusterRadius || (currentClusterBlockState = world.getBlockState(currentClusterPos = centerPos.offset(x, y, z))).is(Blocks.LAVA) || currentClusterBlockState.is((Block)DDBlocks.DARKSLATE.get()) || !currentClusterBlockState.is((Block)DDBlocks.ARIDROCK.get()) && !currentClusterBlockState.is((Block)DDBlocks.ARID_DEEPSLATE.get()) && !currentClusterBlockState.is(BlockTags.BASE_STONE_OVERWORLD) && !currentClusterBlockState.is(Blocks.PACKED_MUD)) continue;
                    world.setBlock(currentClusterPos, ((DuskrockBlock)((Object)DDBlocks.DUSKROCK.get())).defaultBlockState(), 2);
                    ++replacedCount;
                }
            }
        }
    }
}

