/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import com.naterbobber.darkerdepths.blocks.blockentities.GeyserBlockEntity;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GeyserBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public GeyserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)DDBlockEntityTypes.GEYSER.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        if (worldIn.f_46443_) {
            return (Boolean)state.m_61143_((Property)POWERED) == false ? GeyserBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.GEYSER.get()), GeyserBlockEntity::geyserTick) : null;
        }
        return GeyserBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.GEYSER.get()), GeyserBlockEntity::geyserTick);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        boolean isPowered;
        if (!worldIn.m_5776_() && (isPowered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != worldIn.m_276867_(pos)) {
            if (isPowered) {
                worldIn.m_186460_(pos, (Block)this, 4);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource p_60465_) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && !worldIn.m_276867_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (!((Boolean)stateIn.m_61143_((Property)POWERED)).booleanValue()) {
            this.addParticle(worldIn, rand, pos, (Direction)stateIn.m_61143_((Property)FACING));
        }
    }

    private void addParticle(Level worldIn, RandomSource rand, BlockPos pos, Direction facing) {
        BlockPos frontState = null;
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        double xSpeed = 0.0;
        double ySpeed = 0.0;
        double zSpeed = 0.0;
        double speed = 0.07;
        float lavaSpeedX = 2.0f;
        float lavaSpeedY = 2.0f;
        float lavaSpeedZ = 2.0f;
        float lavaSpeedFront = 2000.0f;
        switch (facing) {
            case UP: {
                frontState = pos.m_7494_();
                ySpeed = speed;
                x += 0.5;
                z += 0.5;
                lavaSpeedY = lavaSpeedFront;
                break;
            }
            case DOWN: {
                frontState = pos.m_7495_();
                ySpeed = -speed;
                x += 0.5;
                z += 0.5;
                lavaSpeedY = -lavaSpeedFront;
                break;
            }
            case NORTH: {
                frontState = pos.m_122012_();
                zSpeed = -speed;
                y += 0.5;
                x += 0.5;
                lavaSpeedZ = lavaSpeedFront;
                break;
            }
            case EAST: {
                frontState = pos.m_122029_();
                xSpeed = speed;
                y += 0.5;
                x += 0.5;
                z += 0.5;
                lavaSpeedX = lavaSpeedFront;
                break;
            }
            case SOUTH: {
                frontState = pos.m_122019_();
                zSpeed = speed;
                y += 0.5;
                x += 0.5;
                z += 0.5;
                lavaSpeedZ = -lavaSpeedFront;
                break;
            }
            case WEST: {
                frontState = pos.m_122024_();
                xSpeed = -speed;
                y += 0.5;
                z += 0.5;
                lavaSpeedX = -lavaSpeedFront;
            }
        }
        boolean waterlogged = worldIn.m_8055_(frontState).m_60713_(Blocks.f_49990_);
        if (waterlogged) {
            for (int i = 1; i < 7; ++i) {
                if (!worldIn.m_46859_(pos.m_6630_(i))) continue;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123774_, x, y, z, xSpeed, ySpeed / 2.0, zSpeed);
            worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123774_, x + (double)rand.m_188501_(), y + (double)rand.m_188501_(), z + (double)rand.m_188501_(), xSpeed, ySpeed / 2.0, zSpeed);
            if (rand.m_188503_(200) == 0) {
                worldIn.m_7785_(x, y, z, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.2f + rand.m_188501_() * 0.2f, 0.9f + rand.m_188501_() * 0.15f, false);
            }
        } else {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123777_, x, y, z, xSpeed, ySpeed, zSpeed);
            if (rand.m_188503_(5) == 0) {
                for (int i = 0; i < rand.m_188503_(1) + 1; ++i) {
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, (double)(rand.m_188501_() / lavaSpeedX), (double)(rand.m_188501_() / lavaSpeedY), (double)(rand.m_188501_() / lavaSpeedZ));
                }
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && facingState.m_60713_(Blocks.f_49990_)) {
            worldIn.m_186460_(currentPos, (Block)this, 20);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_213898_(BlockState p_60551_, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        BlockPos blockpos = pos.m_7494_();
        if (worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            worldIn.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.m_188501_() - worldIn.f_46441_.m_188501_()) * 0.8f);
            worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.25, (double)blockpos.m_123343_() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    public void m_6807_(BlockState p_60566_, Level worldIn, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        worldIn.m_186460_(pos, (Block)this, 1);
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, FACING});
    }
}

