/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RopeBlock
extends Block
implements BucketPickup,
LiquidBlockContainer {
    public static final EnumProperty<RopePart> PART = EnumProperty.m_61587_((String)"part", RopePart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public RopeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)((Object)RopePart.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        if (state.m_61143_(PART) == RopePart.BOTTOM) {
            return Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        }
        if (state.m_61143_(PART) == RopePart.MIDDLE) {
            return Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        }
        return Shapes.m_83124_((VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)13.0), Block.m_49796_((double)7.0, (double)12.0, (double)3.0, (double)9.0, (double)16.0, (double)5.0), Block.m_49796_((double)7.0, (double)12.0, (double)5.0, (double)9.0, (double)14.0, (double)11.0)});
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return (worldIn.m_8055_(pos.m_7494_()).m_60783_((BlockGetter)worldIn, pos, Direction.DOWN) || worldIn.m_8055_(pos.m_7494_()).m_60734_() instanceof RopeBlock) && !(worldIn.m_8055_(pos.m_7494_()).m_60734_() instanceof AirBlock);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean water = context.m_43725_().m_8055_(context.m_8083_()).m_60734_() == Blocks.f_49990_;
        BlockState state = super.m_5573_(context);
        if (state != null) {
            if (this.isRopeBottom((LevelAccessor)context.m_43725_(), context.m_8083_())) {
                state = (BlockState)state.m_61124_(PART, (Comparable)((Object)RopePart.BOTTOM));
            } else if (this.isRopeTop((LevelAccessor)context.m_43725_(), context.m_8083_())) {
                state = (BlockState)state.m_61124_(PART, (Comparable)((Object)RopePart.TOP));
            }
        } else {
            return null;
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        worldIn.m_186460_(currentPos, (Block)this, 1);
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        stateIn = this.isRopeBottom(worldIn, currentPos) ? (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)RopePart.BOTTOM)) : (this.isRopeTop(worldIn, currentPos) ? (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)RopePart.TOP)) : (BlockState)stateIn.m_61124_(PART, (Comparable)((Object)RopePart.MIDDLE)));
        return this.m_7898_(stateIn, (LevelReader)worldIn, currentPos) ? super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos) : Blocks.f_50016_.m_49966_();
    }

    public boolean isRopeBottom(LevelAccessor world, BlockPos pos) {
        return !(world.m_8055_(pos.m_7495_()).m_60734_() instanceof RopeBlock);
    }

    public boolean isRopeTop(LevelAccessor world, BlockPos pos) {
        return !(world.m_8055_(pos.m_7494_()).m_60734_() instanceof RopeBlock);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public ItemStack m_142598_(LevelAccessor world, BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6044_(BlockGetter p_54766_, BlockPos p_54767_, BlockState p_54768_, Fluid fluid) {
        return fluid == Fluids.f_76193_;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState p_60550_) {
        return RenderShape.MODEL;
    }

    public static enum RopePart implements StringRepresentable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private RopePart(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

