/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.blocks.blockentities;

import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MobPlacerBlockEntity
extends BlockEntity {
    private String entityTypeId = "";
    private float rotation = 0.0f;
    private CompoundTag entityData = new CompoundTag();
    private boolean hasSpawned = false;
    private int ticksExisted = 0;

    public MobPlacerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)DDBlockEntityTypes.MOB_PLACER.get(), pos, blockState);
    }

    public MobPlacerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MobPlacerBlockEntity blockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++blockEntity.ticksExisted;
        if (blockEntity.ticksExisted < 5) {
            return;
        }
        if (!blockEntity.hasSpawned && !blockEntity.entityTypeId.isEmpty()) {
            blockEntity.spawnEntity(serverLevel);
            blockEntity.hasSpawned = true;
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    private void spawnEntity(ServerLevel level) {
        try {
            ResourceLocation entityId = ResourceLocation.m_135820_((String)this.entityTypeId);
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
            if (entityType == null) {
                return;
            }
            Entity entity = entityType.m_20615_((Level)level);
            if (entity == null) {
                return;
            }
            Vec3 spawnPos = new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5);
            entity.m_146884_(spawnPos);
            if (!this.entityData.m_128456_()) {
                entity.m_20258_(this.entityData);
            }
            entity.m_146922_(this.rotation);
            entity.f_19859_ = this.rotation;
            entity.m_146926_(0.0f);
            entity.f_19860_ = 0.0f;
            entity.m_146884_(spawnPos);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(this.f_58858_), MobSpawnType.STRUCTURE, null, null);
                mob.m_21530_();
                mob.m_146922_(this.rotation);
                mob.f_19859_ = this.rotation;
                mob.m_5616_(this.rotation);
                mob.f_20886_ = this.rotation;
            }
            level.m_7967_(entity);
        }
        catch (Exception e) {
            System.err.println("Error spawning entity " + this.entityTypeId + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.entityTypeId = nbt.m_128461_("EntityType");
        this.rotation = nbt.m_128457_("Rotation");
        this.hasSpawned = nbt.m_128471_("HasSpawned");
        if (nbt.m_128441_("EntityData")) {
            this.entityData = nbt.m_128469_("EntityData");
        }
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("EntityType", this.entityTypeId);
        nbt.m_128350_("Rotation", this.rotation);
        nbt.m_128379_("HasSpawned", this.hasSpawned);
        if (!this.entityData.m_128456_()) {
            nbt.m_128365_("EntityData", (Tag)this.entityData);
        }
    }

    public void setEntityType(String entityTypeId) {
        this.entityTypeId = entityTypeId;
        this.m_6596_();
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.m_6596_();
    }

    public void setEntityData(CompoundTag data) {
        this.entityData = data.m_6426_();
        this.m_6596_();
    }

    public String getEntityTypeId() {
        return this.entityTypeId;
    }

    public float getRotation() {
        return this.rotation;
    }

    public CompoundTag getEntityData() {
        return this.entityData.m_6426_();
    }
}

