/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.particle;

import com.naterbobber.darkerdepths.init.DDParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DrippingParticle
extends TextureSheetParticle {
    private final Fluid fluid;
    protected boolean fullBright;

    public DrippingParticle(ClientLevel p_108323_, double p_108324_, double p_108325_, double p_108326_, Fluid fluid) {
        super(p_108323_, p_108324_, p_108325_, p_108326_);
        this.m_107250_(0.01f, 0.01f);
        this.f_107226_ = 0.06f;
        this.fluid = fluid;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    protected int m_6355_(float p_107249_) {
        return this.fullBright ? 240 : super.m_6355_(p_107249_);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.ageParticle();
        if (!this.f_107220_) {
            this.f_107216_ -= (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.updateMotion();
            if (!this.f_107220_) {
                this.f_107215_ *= (double)0.98f;
                this.f_107216_ *= (double)0.98f;
                this.f_107217_ *= (double)0.98f;
                BlockPos blockpos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
                FluidState fluidstate = this.f_107208_.m_6425_(blockpos);
                if (fluidstate.m_76152_() == this.fluid && this.f_107213_ < (double)((float)blockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_107208_, blockpos))) {
                    this.m_107274_();
                }
            }
        }
    }

    protected void ageParticle() {
        if (this.f_107225_-- <= 0) {
            this.m_107274_();
        }
    }

    protected void updateMotion() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LandingAmberFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public LandingAmberFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Landing landing = new Landing(worldIn, x, y, z, Fluids.f_76191_);
            landing.fullBright = true;
            ((DrippingParticle)landing).f_107225_ = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            landing.m_107253_(0.97f, 0.56f, 0.22f);
            landing.m_108335_(this.spriteSet);
            return landing;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FallingAmberFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public FallingAmberFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FallingLiquid falling = new FallingLiquid(worldIn, x, y, z, Fluids.f_76191_, (ParticleOptions)DDParticleTypes.LANDING_AMBER.get());
            falling.fullBright = true;
            ((DrippingParticle)falling).f_107226_ = 0.01f;
            falling.m_107253_(0.97f, 0.56f, 0.22f);
            falling.m_108335_(this.spriteSet);
            return falling;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DrippingAmberFactory
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet spriteSet;

        public DrippingAmberFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            Dripping dripping = new Dripping(worldIn, x, y, z, Fluids.f_76191_, (ParticleOptions)DDParticleTypes.FALLING_AMBER.get());
            dripping.fullBright = true;
            ((DrippingParticle)dripping).f_107226_ *= 0.01f;
            ((DrippingParticle)dripping).f_107225_ = 100;
            dripping.m_107253_(0.97f, 0.56f, 0.22f);
            dripping.m_108335_(this.spriteSet);
            return dripping;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Landing
    extends DrippingParticle {
        private Landing(ClientLevel world, double x, double y, double z, Fluid fluid) {
            super(world, x, y, z, fluid);
            this.f_107225_ = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Falling
    extends DrippingParticle {
        Falling(ClientLevel world, double x, double y, double z, Fluid fluid) {
            this(world, x, y, z, fluid, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        Falling(ClientLevel world, double x, double y, double z, Fluid fluid, int lifetime) {
            super(world, x, y, z, fluid);
            this.f_107225_ = lifetime;
        }

        @Override
        protected void updateMotion() {
            if (this.f_107218_) {
                this.m_107274_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class FallingLiquid
    extends Falling {
        protected final ParticleOptions nextParticle;

        FallingLiquid(ClientLevel world, double x, double y, double z, Fluid fluid, ParticleOptions nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
        }

        @Override
        protected void updateMotion() {
            if (this.f_107218_) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.nextParticle, this.f_107212_, this.f_107213_, this.f_107214_, 0.0, 0.0, 0.0);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Dripping
    extends DrippingParticle {
        protected final ParticleOptions nextParticle;

        Dripping(ClientLevel world, double x, double y, double z, Fluid fluid, ParticleOptions nextParticle) {
            super(world, x, y, z, fluid);
            this.nextParticle = nextParticle;
            this.f_107226_ *= 0.02f;
            this.f_107225_ = 40;
        }

        @Override
        protected void ageParticle() {
            if (this.f_107225_-- <= 0) {
                this.m_107274_();
                this.f_107208_.m_7106_(this.nextParticle, this.f_107212_, this.f_107213_, this.f_107214_, this.f_107215_, this.f_107216_, this.f_107217_);
            }
        }

        @Override
        protected void updateMotion() {
            this.f_107215_ *= 0.02;
            this.f_107216_ *= 0.02;
            this.f_107217_ *= 0.02;
        }
    }
}

