/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.client.render.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.naterbobber.darkerdepths.blocks.blockentities.TombBlockEntity;
import com.naterbobber.darkerdepths.client.models.TombModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

@OnlyIn(value=Dist.CLIENT)
public class TombBlockEntityRenderer
extends GeoBlockRenderer<TombBlockEntity> {
    public final EntityRenderDispatcher dispatcher;

    public TombBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super((GeoModel)new TombModel());
        this.dispatcher = context.m_234446_();
    }

    public void actuallyRender(PoseStack poseStack, TombBlockEntity animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.isInhabited()) {
            this.renderSkeleton(animatable, partialTick, poseStack, bufferSource, packedLight);
        }
    }

    private void renderSkeleton(TombBlockEntity blockEntity, float partialTick, PoseStack matrices, MultiBufferSource bufferSource, int packedLight) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        Skeleton skeleton = new Skeleton(EntityType.f_20524_, level);
        skeleton.f_20885_ = 0.0f;
        skeleton.f_20886_ = 0.0f;
        ItemStack storedItem = blockEntity.getStoredItem();
        if (!storedItem.m_41619_()) {
            skeleton.m_21008_(InteractionHand.MAIN_HAND, storedItem.m_41777_());
        }
        matrices.m_85836_();
        matrices.m_85837_(1.0, 0.335, 0.5);
        matrices.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        matrices.m_252781_(Axis.f_252403_.m_252977_(90.0f));
        this.dispatcher.m_114384_((Entity)skeleton, 0.0, 0.0, 0.0, 0.0f, partialTick, matrices, bufferSource, packedLight);
        matrices.m_85849_();
    }

    public boolean shouldRenderOffScreen(TombBlockEntity model) {
        return true;
    }
}

