/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulMonster;
import com.naterbobber.darkerdepths.entities.goals.AttackMemoryTargetGoal;
import com.naterbobber.darkerdepths.entities.goals.ConfigurableReachMeleeAttackGoal;
import com.naterbobber.darkerdepths.entities.goals.DashGoal;
import com.naterbobber.darkerdepths.entities.goals.IDashable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BodySnatcherEntity
extends VoidSoulMonster
implements GeoEntity,
IDashable {
    private int attackTick;
    private int damageDelay;
    private Entity attackTarget;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack.swing", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation PRE_DASH = RawAnimation.begin().thenLoop("pre_dash");
    protected static final RawAnimation HURT = RawAnimation.begin().thenLoop("hurt");
    private static final EntityDataAccessor<Boolean> PREPARING_TO_DASH = SynchedEntityData.m_135353_(BodySnatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DASHING = SynchedEntityData.m_135353_(BodySnatcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public BodySnatcherEntity(EntityType<? extends VoidSoulMonster> type, Level level) {
        super(type, level);
        this.f_21364_ = 10;
        this.setOrbHeight(0.35);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22283_, 2.4).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new ConfigurableReachMeleeAttackGoal((PathfinderMob)this, 1.2, true, 1.68f));
        this.f_21346_.m_25352_(4, new AttackMemoryTargetGoal<Player>((Mob)this, Player.class, 100, true));
        this.f_21345_.m_25352_(1, (Goal)new DashGoal((Mob)this, 2.5, 0.2, 10.0, 15, 60, 5));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTick > 0) {
            --this.attackTick;
            if (this.attackTick == 0) {
                this.setAttacking(false);
            }
        }
        if (this.damageDelay > 0) {
            --this.damageDelay;
        }
        if (this.attackTarget == null) {
            return;
        }
        if (!this.attackTarget.m_6084_() || !this.m_6084_()) {
            this.attackTarget = null;
            return;
        }
        if (this.damageDelay == 0) {
            if (this.m_20280_(this.attackTarget) < 6.0) {
                this.attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
            }
            this.attackTarget = null;
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.attackTick == 0) {
            this.setAttacking(true);
            this.attackTick = 20;
            this.damageDelay = 10;
            if (entity instanceof LivingEntity) {
                this.attackTarget = entity;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walkingController", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackingController", 0, this::attackPredicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "dashController", 0, this::dashPredicate)});
    }

    protected <E extends BodySnatcherEntity> PlayState predicate(AnimationState<E> event) {
        return event.setAndContinue(IDLE_ANIM);
    }

    protected <E extends BodySnatcherEntity> PlayState dashPredicate(AnimationState<E> event) {
        if (this.isPreparingToDash()) {
            return event.setAndContinue(PRE_DASH);
        }
        event.getController().stop();
        return PlayState.STOP;
    }

    protected <E extends BodySnatcherEntity> PlayState attackPredicate(AnimationState<E> event) {
        if (this.isAttacking()) {
            if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                event.getController().forceAnimationReset();
                event.getController().setAnimation(ATTACK_ANIM);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12502_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12499_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
    }

    @Override
    public void setPreparingToDash(boolean isPreparing) {
        this.f_19804_.m_135381_(PREPARING_TO_DASH, (Object)isPreparing);
    }

    @Override
    public void setDashing(boolean isDashing) {
        this.f_19804_.m_135381_(DASHING, (Object)isDashing);
    }

    public boolean isPreparingToDash() {
        return (Boolean)this.f_19804_.m_135370_(PREPARING_TO_DASH);
    }

    public boolean isDashing() {
        return (Boolean)this.f_19804_.m_135370_(DASHING);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREPARING_TO_DASH, (Object)false);
        this.f_19804_.m_135372_(DASHING, (Object)false);
    }
}

