/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.entities;

import com.naterbobber.darkerdepths.entities.VoidSoulMonster;
import com.naterbobber.darkerdepths.entities.control.ConfigurableMoveControl;
import com.naterbobber.darkerdepths.entities.goals.AttackMemoryTargetGoal;
import com.naterbobber.darkerdepths.entities.goals.ConfigurableReachMeleeAttackGoal;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VoidSoulKnightEntity
extends VoidSoulMonster
implements GeoEntity {
    private int attackTick;
    private int firstDamageDelay;
    private int secondDamageDelay;
    private boolean firstAttackDone;
    private Entity attackTarget;
    private int dormantCheckCooldown = 0;
    private static final int PERSISTENCE = 600;
    protected static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("move.walk");
    protected static final RawAnimation ATTACK_ANIM = RawAnimation.begin().then("attack.swing", Animation.LoopType.PLAY_ONCE);
    protected static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation DORMANT_ANIM = RawAnimation.begin().thenLoop("dormant");
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> IS_DORMANT = SynchedEntityData.m_135353_(VoidSoulKnightEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public VoidSoulKnightEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_21364_ = 30;
        this.f_21342_ = new ConfigurableMoveControl((Mob)this, 10.0f);
        this.setOrbHeight(1.5);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.17).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 0.85).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        if (!this.isDormant()) {
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21345_.m_25352_(2, (Goal)new ConfigurableReachMeleeAttackGoal((PathfinderMob)this, 1.3, true, 2.75f));
            this.f_21346_.m_25352_(3, new AttackMemoryTargetGoal<Player>((Mob)this, Player.class, 600, true));
            this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackTick > 0) {
            --this.attackTick;
            if (this.attackTick == 0) {
                this.setAttacking(false);
            }
        }
        if (this.firstDamageDelay > 0) {
            --this.firstDamageDelay;
        }
        if (this.secondDamageDelay > 0) {
            --this.secondDamageDelay;
        }
        if (this.attackTarget == null) {
            return;
        }
        if (!this.attackTarget.m_6084_()) {
            this.attackTarget = null;
            return;
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        if (this.firstDamageDelay == 0 && !this.firstAttackDone) {
            this.attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), damage);
            this.firstAttackDone = true;
            return;
        }
        if (this.secondDamageDelay == 0) {
            if (this.m_20280_(this.attackTarget) < 12.0) {
                this.attackTarget.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), damage);
            }
            this.attackTarget = null;
        }
    }

    public void m_8119_() {
        boolean isPeaceful;
        super.m_8119_();
        if (this.dormantCheckCooldown != 0) {
            --this.dormantCheckCooldown;
            return;
        }
        boolean bl = isPeaceful = this.m_9236_().m_46791_() == Difficulty.PEACEFUL;
        if (!this.isDormant()) {
            if (isPeaceful) {
                this.setDormant(true);
            }
            return;
        }
        this.m_5618_(this.m_146908_());
        this.m_5616_(this.m_146908_());
        if (isPeaceful) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            boolean hpChanged;
            Player player = this.m_9236_().m_45930_((Entity)this, 8.0);
            boolean bl2 = hpChanged = this.m_21223_() < this.m_21233_();
            if (player != null && !player.m_7500_() || hpChanged) {
                this.setDormant(false);
                this.m_8099_();
                this.m_6710_((LivingEntity)player);
                this.m_5496_(SoundEvents.f_12009_, 1.0f, 0.4f);
            }
            this.dormantCheckCooldown = 20;
        }
    }

    public void m_7822_(byte id) {
        if (id == 4) {
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.5f);
        } else {
            super.m_7822_(id);
        }
    }

    public int getAttackTick() {
        return this.attackTick;
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() == 0) {
            this.setAttacking(true);
            this.attackTick = 50;
            this.firstDamageDelay = 10;
            this.firstAttackDone = false;
            this.secondDamageDelay = 38;
            if (entity instanceof LivingEntity) {
                this.attackTarget = (LivingEntity)entity;
            }
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            return true;
        }
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12008_;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "walkingController", 5, this::predicate)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackingController", 0, this::attackPredicate)});
    }

    protected <E extends VoidSoulKnightEntity> PlayState predicate(AnimationState<E> event) {
        if (this.isDormant()) {
            return event.setAndContinue(DORMANT_ANIM);
        }
        if (event.isMoving()) {
            return event.setAndContinue(WALK_ANIM);
        }
        return event.setAndContinue(IDLE_ANIM);
    }

    protected <E extends VoidSoulKnightEntity> PlayState attackPredicate(AnimationState<E> event) {
        if (this.isAttacking()) {
            if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                event.getController().forceAnimationReset();
                event.getController().setAnimation(ATTACK_ANIM);
            }
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_DORMANT, (Object)true);
    }

    public boolean isDormant() {
        return (Boolean)this.f_19804_.m_135370_(IS_DORMANT);
    }

    public void setDormant(boolean dormant) {
        this.f_19804_.m_135381_(IS_DORMANT, (Object)dormant);
        this.m_21557_(dormant);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }
}

