/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="darkerdepths", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientDeathAnchorAnimationOverlay {
    private static boolean isOverlayActive = false;
    private static int currentFrame = 1;
    private static int startFrame = 1;
    private static long lastFrameTime = 0L;
    public static final int FRAME_COUNT = 200;
    private static final int FRAME_DURATION_MS = 50;
    public static final List<ResourceLocation> ANIMATION_FRAMES = new ArrayList<ResourceLocation>();

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (!isOverlayActive) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        ClientDeathAnchorAnimationOverlay.updateAnimation();
        ClientDeathAnchorAnimationOverlay.renderOverlay(guiGraphics, screenWidth, screenHeight);
    }

    private static void updateAnimation() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        if (mc.f_91080_ instanceof DeathScreen) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFrameTime >= 50L) {
            if (currentFrame < ANIMATION_FRAMES.size() - 1) {
                ++currentFrame;
                lastFrameTime = currentTime;
            } else if (currentTime - lastFrameTime >= 100L) {
                ClientDeathAnchorAnimationOverlay.stopOverlay();
            }
        }
    }

    private static void renderOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ClientDeathAnchorAnimationOverlay.renderTexturedOverlay(guiGraphics, screenWidth, screenHeight);
        RenderSystem.disableBlend();
        poseStack.m_85849_();
    }

    private static void renderTexturedOverlay(GuiGraphics guiGraphics, int screenWidth, int screenHeight) {
        if (ANIMATION_FRAMES.isEmpty()) {
            return;
        }
        ResourceLocation currentTexture = ANIMATION_FRAMES.get(currentFrame);
        guiGraphics.m_280163_(currentTexture, 0, 0, 0.0f, 0.0f, screenWidth, screenHeight, screenWidth, screenHeight);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void startOverlay() {
        isOverlayActive = true;
        currentFrame = startFrame = 0;
        lastFrameTime = System.currentTimeMillis();
    }

    public static void stopOverlay() {
        isOverlayActive = false;
        currentFrame = 0;
    }

    public static boolean isOverlayActive() {
        return isOverlayActive;
    }

    public static int getCurrentFrame() {
        return currentFrame;
    }

    public static void setFrame(int frame) {
        if (frame >= 0 && frame < ANIMATION_FRAMES.size()) {
            currentFrame = frame;
        }
    }

    static {
        for (int i = startFrame; i <= 200; ++i) {
            ResourceLocation frameLocation = new ResourceLocation("darkerdepths", "textures/gui/death_anchor_overlay/frame_" + i + ".png");
            ANIMATION_FRAMES.add(frameLocation);
        }
    }
}

