/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.init;

import com.naterbobber.darkerdepths.DarkerDepths;
import com.naterbobber.darkerdepths.init.DDBiomes;
import com.naterbobber.darkerdepths.init.DDEntityTypes;
import com.naterbobber.darkerdepths.init.DDPlacedFeatures;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DDBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_MOLTEN_CAVERNS_VEGETAL_FEATURES = DDBiomeModifiers.createKey("add_molten_caverns_vegetal_features");
    public static final ResourceKey<BiomeModifier> ADD_MOLTEN_CAVERNS_ORES = DDBiomeModifiers.createKey("add_molten_caverns_ores");
    public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_LOCAL_MODIFICATIONS = DDBiomeModifiers.createKey("add_sandy_catacombs_local_modifications");
    public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_VEGETAL_FEATURES = DDBiomeModifiers.createKey("add_sandy_catacombs_vegetal_features");
    public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_SPAWNS = DDBiomeModifiers.createKey("add_sandy_catacombs_spawns");
    public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_RAW_GENERATION = DDBiomeModifiers.createKey("add_sandy_catacombs_raw_generation");
    public static final ResourceKey<BiomeModifier> ADD_SANDY_CATACOMBS_UNDERGROUND_DECORATION = DDBiomeModifiers.createKey("add_sandy_catacombs_underground_decoration");
    public static final ResourceKey<BiomeModifier> ADD_GLOWSHROOM_FOREST_VEGETAL_FEATURES = DDBiomeModifiers.createKey("add_glowshroom_forest_vegetal_features");
    public static final ResourceKey<BiomeModifier> ADD_GLOWSHROOM_FOREST_SPAWNS = DDBiomeModifiers.createKey("add_glowshroom_forest_spawns");

    private static ResourceKey<BiomeModifier> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)DarkerDepths.id(name));
    }

    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        context.m_255272_(ADD_MOLTEN_CAVERNS_VEGETAL_FEATURES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.MOLTEN_CAVERN), DDBiomeModifiers.getPlacedFeature(context, DDPlacedFeatures.DARKSLATE_PLACEMENT, DDPlacedFeatures.AMBER, DDPlacedFeatures.MOLTEN_POOL, DDPlacedFeatures.MOLTEN_SPRING), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_MOLTEN_CAVERNS_ORES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.MOLTEN_CAVERN), DDBiomeModifiers.getPlacedFeature(context, DDPlacedFeatures.MAGMA_ORE, DDPlacedFeatures.DEAD_LIVING_CRYSTAL_ORE), GenerationStep.Decoration.UNDERGROUND_ORES));
        context.m_255272_(ADD_SANDY_CATACOMBS_LOCAL_MODIFICATIONS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, new ResourceKey[0]), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        context.m_255272_(ADD_SANDY_CATACOMBS_VEGETAL_FEATURES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, DDPlacedFeatures.PETRIFIED_BRANCH, DDPlacedFeatures.ARID_SURFACE), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_SANDY_CATACOMBS_SPAWNS, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.SANDY_CATACOMBS), List.of(new MobSpawnSettings.SpawnerData(EntityType.f_20554_, 80, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 50, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 95, 2, 4), new MobSpawnSettings.SpawnerData((EntityType)DDEntityTypes.BODY_SNATCHER.get(), 30, 1, 3))));
        context.m_255272_(ADD_SANDY_CATACOMBS_RAW_GENERATION, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, DDPlacedFeatures.ARID_BOULDER, DDPlacedFeatures.DUSKROCK_ORE), GenerationStep.Decoration.RAW_GENERATION));
        context.m_255272_(ADD_SANDY_CATACOMBS_UNDERGROUND_DECORATION, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.SANDY_CATACOMBS), DDBiomeModifiers.getPlacedFeature(context, DDPlacedFeatures.CATACOMBS_LAVA_LINING), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.m_255272_(ADD_GLOWSHROOM_FOREST_VEGETAL_FEATURES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.GLOWSHROOM_FOREST), DDBiomeModifiers.getPlacedFeature(context, DDPlacedFeatures.GLIMMERING_VINES, DDPlacedFeatures.HUGE_GLOWSHROOM, DDPlacedFeatures.GRIME_SURFACE), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.m_255272_(ADD_GLOWSHROOM_FOREST_SPAWNS, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(DDBiomeModifiers.getBiome(context, DDBiomes.GLOWSHROOM_FOREST), List.of(new MobSpawnSettings.SpawnerData((EntityType)DDEntityTypes.GLOWSHROOM_MONSTER.get(), 50, 1, 2))));
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> ... placedFeature) {
        return HolderSet.m_205800_(Stream.of(placedFeature).map(resourceKey -> context.m_255420_(Registries.f_256988_).m_255043_(resourceKey)).collect(Collectors.toList()));
    }

    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeature) {
        return HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(placedFeature)});
    }

    @NotNull
    private static HolderSet.Direct<Biome> getBiome(BootstapContext<BiomeModifier> bootstapContext, ResourceKey<Biome> biome) {
        return HolderSet.m_205809_((Holder[])new Holder[]{bootstapContext.m_255420_(Registries.f_256952_).m_255043_(biome)});
    }
}

