/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CatacombsLavaLiningFeature
extends Feature<NoneFeatureConfiguration> {
    public CatacombsLavaLiningFeature(Codec<NoneFeatureConfiguration> p_65792_) {
        super(p_65792_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource random = context.m_225041_();
        int blocksPlaced = 0;
        int searchRadius = 8;
        for (int x = -searchRadius; x <= searchRadius; ++x) {
            for (int y = -searchRadius; y <= searchRadius; ++y) {
                for (int z = -searchRadius; z <= searchRadius; ++z) {
                    BlockPos currentPos = origin.m_7918_(x, y, z);
                    BlockState blockState = world.m_8055_(currentPos);
                    if (!blockState.m_60713_(Blocks.f_49991_)) continue;
                    for (Direction direction : Direction.values()) {
                        BlockPos adjacentPos = currentPos.m_121945_(direction);
                        BlockState adjacentBlockState = world.m_8055_(adjacentPos);
                        if (adjacentBlockState.m_60713_(Blocks.f_49991_) || !adjacentBlockState.m_204336_(BlockTags.f_13061_) && !adjacentBlockState.m_60713_((Block)DDBlocks.ARID_DEEPSLATE.get()) && !adjacentBlockState.m_60713_((Block)DDBlocks.ARIDROCK.get()) && !adjacentBlockState.m_60713_((Block)DDBlocks.DUSKROCK.get()) && !adjacentBlockState.m_60713_(Blocks.f_220843_)) continue;
                        world.m_7731_(adjacentPos, ((Block)DDBlocks.DARKSLATE.get()).m_49966_(), 2);
                        ++blocksPlaced;
                        if (world.m_8055_(adjacentPos.m_7494_()).m_60713_((Block)DDBlocks.DRY_SPROUTS.get())) {
                            world.m_7731_(adjacentPos.m_7494_(), Blocks.f_50016_.m_49966_(), 2);
                        }
                        this.placeCluster(world, adjacentPos, random);
                    }
                }
            }
        }
        return blocksPlaced > 0;
    }

    public void placeCluster(WorldGenLevel world, BlockPos centerPos, RandomSource random) {
        int clusterRadius = 1 + random.m_188503_(2);
        int replacedCount = 0;
        for (int x = -clusterRadius; x <= clusterRadius; ++x) {
            for (int y = -clusterRadius; y <= clusterRadius; ++y) {
                for (int z = -clusterRadius; z <= clusterRadius; ++z) {
                    BlockPos currentClusterPos;
                    BlockState currentClusterBlockState;
                    if (x * x + y * y + z * z > clusterRadius * clusterRadius || (currentClusterBlockState = world.m_8055_(currentClusterPos = centerPos.m_7918_(x, y, z))).m_60713_(Blocks.f_49991_) || currentClusterBlockState.m_60713_((Block)DDBlocks.DARKSLATE.get()) || !currentClusterBlockState.m_60713_((Block)DDBlocks.ARIDROCK.get()) && !currentClusterBlockState.m_60713_((Block)DDBlocks.ARID_DEEPSLATE.get()) && !currentClusterBlockState.m_204336_(BlockTags.f_13061_) && !currentClusterBlockState.m_60713_(Blocks.f_220843_)) continue;
                    world.m_7731_(currentClusterPos, ((Block)DDBlocks.DUSKROCK.get()).m_49966_(), 2);
                    ++replacedCount;
                }
            }
        }
    }
}

