/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.world.gen.features;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.world.gen.features.config.CorrespondentLayersConfig;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class CorrespondentLayersFeature
extends Feature<CorrespondentLayersConfig> {
    public CorrespondentLayersFeature(Codec<CorrespondentLayersConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<CorrespondentLayersConfig> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        CorrespondentLayersConfig config = (CorrespondentLayersConfig)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos blockpos = context.m_159777_();
        Predicate<BlockState> predicate = state -> state.m_204336_(config.replaceable);
        int i = config.xzRadius.m_214085_(random) + 1;
        int j = config.xzRadius.m_214085_(random) + 1;
        Set<BlockPos> set = this.placeGroundPatch(worldgenlevel, config, random, blockpos, predicate, i, j);
        this.distributeVegetation(context, worldgenlevel, config, random, set, i, j);
        return !set.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(WorldGenLevel world, CorrespondentLayersConfig config, RandomSource random, BlockPos pos, Predicate<BlockState> predicate, int xRadius, int zRadius) {
        BlockPos.MutableBlockPos mut = pos.m_122032_();
        BlockPos.MutableBlockPos mut1 = mut.m_122032_();
        Direction direction = config.surface.m_162107_();
        Direction direction1 = direction.m_122424_();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = -xRadius; i <= xRadius; ++i) {
            boolean flag = i == -xRadius || i == xRadius;
            for (int j = -zRadius; j <= zRadius; ++j) {
                boolean flag4;
                boolean flag1 = j == -zRadius || j == zRadius;
                boolean flag2 = flag || flag1;
                boolean flag3 = flag && flag1;
                boolean bl = flag4 = flag2 && !flag3;
                if (flag3 || flag4 && (config.extraEdgeColumnChance == 0.0f || random.m_188501_() > config.extraEdgeColumnChance)) continue;
                mut.m_122154_((Vec3i)pos, i, 0, j);
                for (int k = 0; world.m_7433_((BlockPos)mut, DripstoneUtils::m_159664_) && k < config.verticalRange; ++k) {
                    mut.m_122173_(direction);
                }
                for (int i1 = 0; world.m_7433_((BlockPos)mut, state -> !DripstoneUtils.m_159664_((BlockState)state)) && i1 < config.verticalRange; ++i1) {
                    mut.m_122173_(direction1);
                }
                mut1.m_122159_((Vec3i)mut, config.surface.m_162107_());
                BlockState blockstate = world.m_8055_((BlockPos)mut1);
                if (!world.m_7433_((BlockPos)mut, DripstoneUtils::m_159664_) || !blockstate.m_60783_((BlockGetter)world, (BlockPos)mut1, config.surface.m_162107_().m_122424_())) continue;
                int l = config.depth.m_214085_(random) + (config.extraBottomBlockChance > 0.0f && random.m_188501_() < config.extraBottomBlockChance ? 1 : 0);
                BlockPos blockpos = mut1.m_7949_();
                boolean flag5 = this.placeGround(world, config, predicate, random, mut1, l);
                if (!flag5) continue;
                set.add(blockpos);
            }
        }
        return set;
    }

    protected void distributeVegetation(FeaturePlaceContext<CorrespondentLayersConfig> context, WorldGenLevel world, CorrespondentLayersConfig config, RandomSource random, Set<BlockPos> pos, int p_160619_, int p_160620_) {
        for (BlockPos blockpos : pos) {
            if (!(config.vegetationChance > 0.0f) || !(random.m_188501_() < config.vegetationChance)) continue;
            this.placeVegetation(world, config, context.m_159775_(), random, blockpos);
        }
    }

    protected boolean placeVegetation(WorldGenLevel world, CorrespondentLayersConfig config, ChunkGenerator generator, RandomSource random, BlockPos pos) {
        if (world.m_7433_(pos.m_121945_(config.surface.m_162107_().m_122424_()), BlockBehaviour.BlockStateBase::m_60795_) && world.m_8055_(pos).m_60713_(config.layers.get(0).m_213972_(random, pos).m_60734_())) {
            return ((PlacedFeature)config.vegetationFeature.get()).m_226357_(world, generator, random, pos.m_121945_(config.surface.m_162107_().m_122424_()));
        }
        return false;
    }

    protected boolean placeGround(WorldGenLevel world, CorrespondentLayersConfig config, Predicate<BlockState> predicate, RandomSource random, BlockPos.MutableBlockPos pos, int tries) {
        for (int i = 0; i < tries; ++i) {
            BlockState blockstate = config.layers.get(0).m_213972_(random, (BlockPos)pos);
            BlockState belowState = config.layers.get(1).m_213972_(random, (BlockPos)pos);
            BlockState posBelow = world.m_8055_(pos.m_7495_());
            if (blockstate == ((Block)DDBlocks.ARIDROCK.get()).m_49966_() && (world.m_8055_((BlockPos)pos).m_60713_((Block)DDBlocks.DUSKROCK.get()) || posBelow.m_60713_((Block)DDBlocks.DUSKROCK.get()))) continue;
            if (blockstate == ((Block)DDBlocks.ARIDROCK.get()).m_49966_() && !posBelow.m_60713_(Blocks.f_152550_) && !posBelow.m_60713_(Blocks.f_152496_)) {
                belowState = ((Block)DDBlocks.ARIDROCK.get()).m_49966_();
            }
            if (posBelow.m_60713_(Blocks.f_152496_) || posBelow.m_60713_(Blocks.f_152550_)) {
                world.m_7731_(pos.m_7495_(), belowState, 2);
                world.m_7731_((BlockPos)pos, blockstate, 2);
                if (!config.xzReplace) continue;
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (world.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_152550_) && world.m_8055_(pos.m_121945_(direction).m_7494_()).m_247087_()) {
                        world.m_7731_(pos.m_121945_(direction), ((Block)DDBlocks.ARID_DEEPSLATE.get()).m_49966_(), 2);
                        continue;
                    }
                    if (!world.m_8055_(pos.m_7495_().m_121945_(direction)).m_60713_(Blocks.f_152550_) || !world.m_8055_(pos.m_121945_(direction)).m_247087_()) continue;
                    world.m_7731_(pos.m_7495_().m_121945_(direction), ((Block)DDBlocks.ARIDROCK.get()).m_49966_(), 2);
                }
                continue;
            }
            if (!posBelow.m_204336_(BlockTags.f_13061_)) continue;
            belowState = belowState.m_60713_((Block)DDBlocks.ARID_DEEPSLATE.get()) ? ((Block)DDBlocks.ARIDROCK.get()).m_49966_() : belowState;
            world.m_7731_(pos.m_7495_(), belowState, 2);
            world.m_7731_((BlockPos)pos, blockstate, 2);
        }
        return true;
    }
}

