/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.blockentities;

import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MobPlacerBlockEntity
extends BlockEntity {
    private String entityTypeId = "";
    private float rotation = 0.0f;
    private CompoundTag entityData = new CompoundTag();
    private boolean hasSpawned = false;
    private int ticksExisted = 0;

    public MobPlacerBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)DDBlockEntityTypes.MOB_PLACER.get(), pos, blockState);
    }

    public MobPlacerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, MobPlacerBlockEntity blockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++blockEntity.ticksExisted;
        if (blockEntity.ticksExisted < 5) {
            return;
        }
        if (!blockEntity.hasSpawned && !blockEntity.entityTypeId.isEmpty()) {
            blockEntity.spawnEntity(serverLevel);
            blockEntity.hasSpawned = true;
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    private void spawnEntity(ServerLevel level) {
        try {
            ResourceLocation entityId = ResourceLocation.parse((String)this.entityTypeId);
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityId);
            Entity entity = entityType.create((Level)level);
            if (entity == null) {
                return;
            }
            Vec3 spawnPos = new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY(), (double)this.worldPosition.getZ() + 0.5);
            entity.setPos(spawnPos);
            if (!this.entityData.isEmpty()) {
                entity.load(this.entityData);
            }
            entity.setYRot(this.rotation);
            entity.yRotO = this.rotation;
            entity.setXRot(0.0f);
            entity.xRotO = 0.0f;
            entity.setPos(spawnPos);
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(this.worldPosition), MobSpawnType.STRUCTURE, null);
                mob.setPersistenceRequired();
                mob.setYRot(this.rotation);
                mob.yRotO = this.rotation;
                mob.setYHeadRot(this.rotation);
                mob.yHeadRotO = this.rotation;
            }
            level.addFreshEntity(entity);
        }
        catch (Exception e) {
            System.err.println("Error spawning entity " + this.entityTypeId + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.entityTypeId = nbt.getString("EntityType");
        this.rotation = nbt.getFloat("Rotation");
        this.hasSpawned = nbt.getBoolean("HasSpawned");
        if (nbt.contains("EntityData")) {
            this.entityData = nbt.getCompound("EntityData");
        }
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putString("EntityType", this.entityTypeId);
        nbt.putFloat("Rotation", this.rotation);
        nbt.putBoolean("HasSpawned", this.hasSpawned);
        if (!this.entityData.isEmpty()) {
            nbt.put("EntityData", (Tag)this.entityData);
        }
    }

    public void setEntityType(String entityTypeId) {
        this.entityTypeId = entityTypeId;
        this.setChanged();
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.setChanged();
    }

    public void setEntityData(CompoundTag data) {
        this.entityData = data.copy();
        this.setChanged();
    }

    public String getEntityTypeId() {
        return this.entityTypeId;
    }

    public float getRotation() {
        return this.rotation;
    }

    public CompoundTag getEntityData() {
        return this.entityData.copy();
    }
}

