/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.custom;

import com.naterbobber.darkerdepths.block.DDBlockStateProperties;
import com.naterbobber.darkerdepths.block.custom.LivingCrystalBlock;
import com.naterbobber.darkerdepths.init.DDBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DeadLivingCrystalBlock
extends Block {
    private static final IntegerProperty CRYSTAL_GROWTH_LEVEL = DDBlockStateProperties.CRYSTAL_GROWTH_LEVEL;

    public DeadLivingCrystalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CRYSTAL_GROWTH_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CRYSTAL_GROWTH_LEVEL});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.DIAMOND) && (Integer)blockState.getValue((Property)CRYSTAL_GROWTH_LEVEL) == 0) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)CRYSTAL_GROWTH_LEVEL, (Comparable)Integer.valueOf(1)), 2);
            level.playSound(null, blockPos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.scheduleTick(blockPos, (Block)this, 1);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, blockState, level, blockPos, player, hand, hitResult);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        int cracked = (Integer)state.getValue((Property)CRYSTAL_GROWTH_LEVEL);
        if (cracked < 3 && cracked != 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CRYSTAL_GROWTH_LEVEL, (Comparable)Integer.valueOf(cracked + 1)), 2);
            level.playSound(null, pos, SoundEvents.TURTLE_EGG_CRACK, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.scheduleTick(pos, (Block)this, 20);
        } else if (cracked == 3) {
            level.setBlockAndUpdate(pos, ((LivingCrystalBlock)((Object)DDBlocks.LIVING_CRYSTAL.get())).defaultBlockState());
            level.playSound(null, pos, SoundEvents.DEEPSLATE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

