/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.custom;

import com.naterbobber.darkerdepths.api.DeathAnchorLocation;
import com.naterbobber.darkerdepths.init.DDBlocks;
import com.naterbobber.darkerdepths.init.DDItems;
import com.naterbobber.darkerdepths.init.DDPoiTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DeathAnchorBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public DeathAnchorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPE;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)DDItems.VOID_SOUL_REQUIEM.get()) && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlock(blockPos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            level.playSound(null, blockPos, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
            if (player instanceof DeathAnchorLocation) {
                DeathAnchorLocation deathAnchorLocation = (DeathAnchorLocation)player;
                this.handleExistingDeathAnchor(level, blockPos, deathAnchorLocation);
                deathAnchorLocation.setDeathAnchorLocation(Optional.of(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)blockPos)));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, blockPos, player, hand, result);
    }

    private void handleExistingDeathAnchor(Level level, BlockPos current, DeathAnchorLocation deathAnchorLocation) {
        Optional<GlobalPos> deathAnchorLocation1 = deathAnchorLocation.getDeathAnchorLocation();
        if (deathAnchorLocation1.isPresent() && level instanceof ServerLevel) {
            ServerLevel newServer;
            ServerLevel serverLevel = (ServerLevel)level;
            GlobalPos globalPos = deathAnchorLocation1.get();
            ResourceKey resourcekey = globalPos.dimension();
            ResourceKey key = DDPoiTypes.DEATH_ANCHOR.getKey();
            BlockPos pos = globalPos.pos();
            if (pos.equals((Object)current)) {
                return;
            }
            if (key != null && (newServer = serverLevel.getServer().getLevel(resourcekey)) != null && newServer.getPoiManager().existsAtPosition(key, pos)) {
                newServer.scheduleTick(pos, (Block)DDBlocks.DEATH_ANCHOR.get(), 2);
                newServer.setBlock(pos, (BlockState)((DeathAnchorBlock)((Object)DDBlocks.DEATH_ANCHOR.get())).defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public void tick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        serverLevel.playSound(null, blockPos, (SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

