/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.custom;

import com.mojang.serialization.MapCodec;
import com.naterbobber.darkerdepths.block.blockentities.GeyserBlockEntity;
import com.naterbobber.darkerdepths.init.DDBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class GeyserBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public GeyserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())))).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)DDBlockEntityTypes.GEYSER.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level worldIn, BlockState state, BlockEntityType<T> blockEntityType) {
        if (worldIn.isClientSide) {
            return (Boolean)state.getValue((Property)POWERED) == false ? GeyserBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.GEYSER.get()), GeyserBlockEntity::geyserTick) : null;
        }
        return GeyserBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)DDBlockEntityTypes.GEYSER.get()), GeyserBlockEntity::geyserTick);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        boolean isPowered;
        if (!worldIn.isClientSide() && (isPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != worldIn.hasNeighborSignal(pos)) {
            if (isPowered) {
                worldIn.scheduleTick(pos, (Block)this, 4);
            } else {
                worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource p_60465_) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos)) {
            worldIn.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (!((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            this.addParticle(worldIn, rand, pos, (Direction)stateIn.getValue((Property)FACING));
        }
    }

    private void addParticle(Level worldIn, RandomSource rand, BlockPos pos, Direction facing) {
        BlockPos frontState = null;
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        double xSpeed = 0.0;
        double ySpeed = 0.0;
        double zSpeed = 0.0;
        double speed = 0.07;
        float lavaSpeedX = 2.0f;
        float lavaSpeedY = 2.0f;
        float lavaSpeedZ = 2.0f;
        float lavaSpeedFront = 2000.0f;
        switch (facing) {
            case UP: {
                frontState = pos.above();
                ySpeed = speed;
                x += 0.5;
                z += 0.5;
                lavaSpeedY = lavaSpeedFront;
                break;
            }
            case DOWN: {
                frontState = pos.below();
                ySpeed = -speed;
                x += 0.5;
                z += 0.5;
                lavaSpeedY = -lavaSpeedFront;
                break;
            }
            case NORTH: {
                frontState = pos.north();
                zSpeed = -speed;
                y += 0.5;
                x += 0.5;
                lavaSpeedZ = lavaSpeedFront;
                break;
            }
            case EAST: {
                frontState = pos.east();
                xSpeed = speed;
                y += 0.5;
                x += 0.5;
                z += 0.5;
                lavaSpeedX = lavaSpeedFront;
                break;
            }
            case SOUTH: {
                frontState = pos.south();
                zSpeed = speed;
                y += 0.5;
                x += 0.5;
                z += 0.5;
                lavaSpeedZ = -lavaSpeedFront;
                break;
            }
            case WEST: {
                frontState = pos.west();
                xSpeed = -speed;
                y += 0.5;
                z += 0.5;
                lavaSpeedX = -lavaSpeedFront;
            }
        }
        boolean waterlogged = worldIn.getBlockState(frontState).is(Blocks.WATER);
        if (waterlogged) {
            for (int i = 1; i < 7; ++i) {
                if (!worldIn.isEmptyBlock(pos.above(i))) continue;
                worldIn.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x, y, z, xSpeed, ySpeed / 2.0, zSpeed);
            worldIn.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.BUBBLE_COLUMN_UP, x + (double)rand.nextFloat(), y + (double)rand.nextFloat(), z + (double)rand.nextFloat(), xSpeed, ySpeed / 2.0, zSpeed);
            if (rand.nextInt(200) == 0) {
                worldIn.playLocalSound(x, y, z, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        } else {
            worldIn.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, xSpeed, ySpeed, zSpeed);
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, (double)(rand.nextFloat() / lavaSpeedX), (double)(rand.nextFloat() / lavaSpeedY), (double)(rand.nextFloat() / lavaSpeedZ));
                }
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && facingState.is(Blocks.WATER)) {
            worldIn.scheduleTick(currentPos, (Block)this, 20);
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void randomTick(BlockState p_60551_, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        BlockPos blockpos = pos.above();
        if (worldIn.getFluidState(pos).is(FluidTags.WATER)) {
            worldIn.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.8f);
            worldIn.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.25, (double)blockpos.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    public void onPlace(BlockState p_60566_, Level worldIn, BlockPos pos, BlockState p_60569_, boolean p_60570_) {
        worldIn.scheduleTick(pos, (Block)this, 1);
    }

    public RenderShape getRenderShape(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, FACING});
    }
}

