/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WallVoidSoulTorchBlock
extends WallTorchBlock {
    protected final Supplier<ParticleOptions> customParticleSupplier;

    public WallVoidSoulTorchBlock(Supplier<ParticleOptions> particleSupplier, BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties);
        this.customParticleSupplier = particleSupplier;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        double xOffset = 0.3 * (double)direction.getStepX();
        double zOffset = 0.3 * (double)direction.getStepZ();
        double particleX = (double)pos.getX() + 0.5 - xOffset;
        double particleY = (double)pos.getY() + 0.73;
        double particleZ = (double)pos.getZ() + 0.5 - zOffset;
        level.addParticle(this.customParticleSupplier.get(), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
    }
}

