/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.block.generic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class WoodPostBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_X = Block.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SHAPE_Y = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_Z = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty[] CHAINED = new BooleanProperty[]{BooleanProperty.create((String)"chain_down"), BooleanProperty.create((String)"chain_up"), BooleanProperty.create((String)"chain_north"), BooleanProperty.create((String)"chain_south"), BooleanProperty.create((String)"chain_west"), BooleanProperty.create((String)"chain_east")};
    public Block strippedBlock = null;

    public WoodPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = (BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(AXIS, (Comparable)Direction.Axis.Y);
        for (BooleanProperty prop : CHAINED) {
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (this.strippedBlock == null || itemAbility != ItemAbility.get((String)"axe")) {
            return super.getToolModifiedState(state, context, itemAbility, simulate);
        }
        BlockState newState = this.strippedBlock.defaultBlockState();
        for (Property property : state.getProperties()) {
            newState = (BlockState)newState.setValue(property, state.getValue(property));
        }
        return newState;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.X -> SHAPE_X;
            case Direction.Axis.Y -> SHAPE_Y;
            default -> SHAPE_Z;
        };
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getState(context.getLevel(), context.getClickedPos(), context.getClickedFace().getAxis());
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, worldIn, pos, blockIn, fromPos, isMoving);
        BlockState newState = this.getState(worldIn, pos, (Direction.Axis)state.getValue(AXIS));
        if (!newState.equals(state)) {
            worldIn.setBlockAndUpdate(pos, newState);
        }
    }

    private BlockState getState(Level world, BlockPos pos, Direction.Axis axis) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER))).setValue(AXIS, (Comparable)axis);
        for (Direction d : Direction.values()) {
            BlockState sideState;
            if (d.getAxis() == axis || (!((sideState = world.getBlockState(pos.relative(d))).getBlock() instanceof ChainBlock) || sideState.getValue((Property)BlockStateProperties.AXIS) != d.getAxis()) && (d != Direction.DOWN || !(sideState.getBlock() instanceof LanternBlock) || !((Boolean)sideState.getValue((Property)LanternBlock.HANGING)).booleanValue())) continue;
            BooleanProperty prop = CHAINED[d.ordinal()];
            state = (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, AXIS});
        for (BooleanProperty booleanProperty : CHAINED) {
            builder.add(new Property[]{booleanProperty});
        }
    }
}

